package com.pangding.web.authority.controller;


import com.pangding.web.authority.util.RsaConstant;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.resvo.WebUserResVo;
import com.pangding.web.util.RSAUtils;
import com.pangding.web.vo.system.pd.authority.UserVo;
import com.pangding.web.vo.system.req.authority.SaveUserReqVo;
import com.pangding.web.vo.system.req.authority.UserReqVo;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping(value = "/user")
@Api(value = "用户相关类", description = "用户新增，修改，删除等相关操作")
public class UserController {

    @Autowired
    UserService userServiceImpl;

    /**
     * 新增用户
     * 返回用户id
     * @param webUserReqVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> saveUser(@RequestBody WebUserReqVo webUserReqVo) throws Exception {
        CheckerHelper.newInstance()
                .notBlankCheck("account",webUserReqVo.getAccount())
                .notBlankCheck("password",webUserReqVo.getPassword())
                .notBlankCheck("confirmPassword",webUserReqVo.getConfirmPassword())
                .checkPhoneNo("phone",webUserReqVo.getPhone())
                .notBlankCheck("companyId",webUserReqVo.getCompanyId())
                .notBlankCheck("email",webUserReqVo.getEmail())
                .checkException();
        return ResponseResult.result(userServiceImpl.saveUser(webUserReqVo));
    }

    /**
     * 修改用户信息
     * 返回用户id
     * @param
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> updateUser(@RequestBody WebUserReqVo webUserReqVo){
        try{
            if(!StringHelper.isEmpty(webUserReqVo.getUpdateType()) && 1 == webUserReqVo.getUpdateType()){
                // 修改密码
                CheckerHelper.newInstance()
                        .notBlankCheck("id",webUserReqVo.getId())
                        .notBlankCheck("password",webUserReqVo.getPassword())
                        .notBlankCheck("confirmPassword",webUserReqVo.getConfirmPassword())
                        .checkException();
                String password = RSAUtils.decryptionByPrivateKey(webUserReqVo.getPassword(), RsaConstant.privateKey);
                String confirmPassword = RSAUtils.decryptionByPrivateKey(webUserReqVo.getConfirmPassword(),RsaConstant.privateKey);
                if (!StringHelper.compare(password,confirmPassword)){
                    throw new CodeException("两次密码输入不一致");
                }
                webUserReqVo.setPassword(password);
                webUserReqVo.setConfirmPassword(confirmPassword);
            }else{
                CheckerHelper.newInstance()
                        .notBlankCheck("account",webUserReqVo.getAccount())
                        .notBlankCheck("password",webUserReqVo.getPassword())
                        .checkPhoneNo("phone",webUserReqVo.getPhone())
                        .notBlankCheck("companyId",webUserReqVo.getCompanyId())
                        .checkException();
            }
            return ResponseResult.result(userServiceImpl.updateUser(webUserReqVo));
        }catch (Exception e){
              return ResponseResult.error("99", e.getMessage());
        }

    }

    /**
     * 查询用户列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebUserResVo>> listUsers(@RequestBody ListUserReqVo reqVo){
        return ResponseResult.result(userServiceImpl.getWebUserResVoList(reqVo));
    }

    /**
     * 查询公司用户列表(新)
     * @return
     */
    @RequestMapping(value = "/userList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询用户列表", notes = "返回用户列表信息.")
    public ResponseResult<PageSizeData<UserVo>> userList(@RequestBody ListUserReqVo reqVo){
        return ResponseResult.result(userServiceImpl.getUserVoList(reqVo));
    }

    @RequestMapping(value = "/updateUserInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "只修改用户信息", notes = "返回修改结果.")
    public ResponseResult updateUserInfo(@RequestBody UserReqVo req){
        CheckerHelper.newInstance().notBlankCheck("id", req.getId()).checkException();
        return ResponseResult.result(userServiceImpl.updateUserInfo(req));
    }

    /**
     * 根据ID查询用户
     * @param //id
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<WebUserResVo> user(@RequestBody WebUserReqVo webUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("userId",webUserReqVo.getId())
                .checkException();
        return ResponseResult.result(userServiceImpl.getUserById(webUserReqVo.getId()));
    }

    /**
     * 注册用户（新）
     * @param //id
     * @return
     */
    @ApiOperation(value ="注册", notes = "返回注册信息")
    @RequestMapping(value = "/registerUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> registerUser(@RequestBody SaveUserReqVo saveUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("account",saveUserReqVo.getAccount())
                .notBlankCheck("password", saveUserReqVo.getPassword())
                .notBlankCheck("confirmPassword", saveUserReqVo.getConfirmPassword())
                .notBlankCheck("companyType", saveUserReqVo.getCompanyType())
                .notBlankCheck("invitationCode", saveUserReqVo.getInvitationCode())
                .checkException();
        return userServiceImpl.registerSaveUser(saveUserReqVo);
    }



}
