package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyDivideRuleDao;
import com.pangding.web.authority.vo.reqvo.GetCompanyReqVo;
import com.pangding.web.authority.vo.resvo.GetCompanyDivideResVo;
import com.pangding.web.vo.system.pd.company.CompanyDivideRuleVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

@Component
public class CompanyDivideRuleDaoImpl extends BaseDaoImpl implements CompanyDivideRuleDao {

    private static final String QUERY_LIST = "QUERY_LIST";

    @Override
    protected void init() {
        register(CompanyDivideRuleVo.class);

        table.add(QUERY_LIST, "select cdr.*,ce.divide_status,c.company_name,c.pid,c.invitation_company_id from pd_company_divide_rule cdr " +
                "left join pd_company c on c.id = cdr.company_id " +
                "left join pd_company_extend ce on c.id = ce.id where 1=1 ")
        .add("companyId"," and cdr.company_id = ?");
    }

    @Override
    public GetCompanyDivideResVo findCompanyDivideInfo(GetCompanyReqVo req){
       return this.queryFirst(GetCompanyDivideResVo.class, QUERY_LIST, req);
    }
}
