package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.service.DataService;
import com.pangding.web.authority.util.CompanyConstant;
import com.pangding.web.authority.util.RoleConstant;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.FindResVo;
import com.pangding.web.authority.vo.resvo.OrderStepOneResVo;
import com.pangding.web.authority.vo.resvo.OrderStepThreeResVo;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/6/12 15:45
 */
@Service
public class DataServiceImpl implements DataService {
    @Autowired
    private CompanyDao companyDaoImpl;
    @Autowired
    private UserDao userDaoImpl;
    @Autowired
    private CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    private CompanyBankCardDao companyBankCardDaoImpl;
    @Autowired
    private UserRoleDao userRoleDaoImpl;
    @Autowired
    private OrderDao orderDaoImpl;
    @Autowired
    private OrderExtendDao orderExtendDaoImpl;
    @Autowired
    private OrderRefundDao orderRefundDaoImpl;
    @Autowired
    private OrderStatusDao orderStatusDaoImpl;
    @Autowired
    private OrderTicketDetailDao orderTicketDetailDao;
    @Autowired
    private OrderTouristDao orderTouristDao;
    @Autowired
    private DiscountDetailDao discountDetailDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(FindResVo reqVo) {

        TyyCompanyVo tyyCompanyVo = reqVo.getTyyCompanyVo();
        TyyCompanyExtendVo tyyCompanyExtendVo = reqVo.getTyyCompanyExtendVo();
        EnterpriseVo enterpriseVo = reqVo.getEnterpriseVo();
        List<EnterpriseBankVo> enterpriseBankVoList = reqVo.getEnterpriseBankVoList();

        /*保存公司主表*/
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(tyyCompanyVo.getId());
        companyVo.setPid(tyyCompanyVo.getPid());
        companyVo.setInvitationCompanyId(tyyCompanyVo.getInvatationId());
        companyVo.setNature(tyyCompanyVo.getCompanyType());
        if (tyyCompanyVo.getCompanyType() == 1 || tyyCompanyVo.getCompanyType() == 2){
            companyVo.setCompanyType(1);
        }else if (tyyCompanyVo.getCompanyType() == 3){
            companyVo.setCompanyType(0);
        }
        companyVo.setCompanyName(tyyCompanyVo.getCompanyName());
        companyVo.setAddress(tyyCompanyVo.getCompanyAddress());
        companyVo.setBusinessLicenseCode(tyyCompanyVo.getCompanyCardNo());
        companyVo.setContactName(tyyCompanyVo.getContactName());
        companyVo.setContactCode(tyyCompanyVo.getContactNo());
        companyVo.setContactPhone(tyyCompanyVo.getContactTel());
        companyVo.setStatus(tyyCompanyVo.getStatus());
        companyVo.setCreateTime(tyyCompanyVo.getCreateTime());
        if (null == enterpriseVo.getExamine()){
            companyVo.setExamineStatus(0);
        }else {
            companyVo.setExamineStatus(Integer.parseInt(enterpriseVo.getExamine()));
        }
        if (null == enterpriseVo.getUsertype()){
            companyVo.setCompanyAttribute(0);
        }else {
            companyVo.setCompanyAttribute(Integer.parseInt(enterpriseVo.getUsertype()));
        }
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        if (null != tyyCompanyExtendVo ){
            companyVo.setElectromicAgreementCode(tyyCompanyExtendVo.getCode());
            companyVo.setSigningStatus(tyyCompanyExtendVo.getStatus());
        }
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(companyVo.getId());
        CompanyVo companyVo1 = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        if (null == companyVo1){
            companyDaoImpl.create(companyVo);
        }else{
            companyDaoImpl.update(companyVo);
        }

        /*保存用户表*/
        UserVo userVo = new UserVo();
        userVo.setId(StringHelper.getNewID());
        userVo.setCompanyId(enterpriseVo.getId());
        userVo.setAccount(enterpriseVo.getAccount());
        userVo.setPassword(enterpriseVo.getPasswd());
        userVo.setRemark(enterpriseVo.getPlainPassword());
        userVo.setName(tyyCompanyVo.getContactName());
        userVo.setPhone(tyyCompanyVo.getContactTel());
        userVo.setCreateTime(tyyCompanyVo.getCreateTime());
        userVo.setEmail(enterpriseVo.getEmail());
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setAccount(userVo.getAccount());
        UserVo userVo1 = userDaoImpl.load(userGetReqVo,UserVo.class);
        if (null == userVo1){
            userDaoImpl.create(userVo);
            /*给用户分配管理员角色*/
            UserRoleVo userRoleVo = new UserRoleVo();
            userRoleVo.setUserId(userVo.getId());
            userRoleVo.setRoleId(RoleConstant.ADMIN_ROLE_ID);
            userRoleDaoImpl.create(userRoleVo);
        }else{
            userVo.setId(userVo1.getId());
            userDaoImpl.update(userVo);
            /*给用户分配管理员角色*/
            UserRoleVo userRoleVo = new UserRoleVo();
            userRoleVo.setUserId(userVo1.getId());
            userRoleVo.setRoleId(RoleConstant.ADMIN_ROLE_ID);
            UserRoleVo userRoleVo1 = userRoleDaoImpl.load(userRoleVo,UserRoleVo.class);
            if (null == userRoleVo1){
                userRoleVo.setId(StringHelper.getNewID());
                userRoleDaoImpl.create(userRoleVo);
            }
        }

        /*保存公司扩展表*/
        CompanyExtendVo companyExtendVo = new CompanyExtendVo();
        companyExtendVo.setId(tyyCompanyVo.getId());
        companyExtendVo.setQrCodeUrl(enterpriseVo.getQrcodepath());
        companyExtendVo.setQrCode(enterpriseVo.getQrcodesrc());
        companyExtendVo.setInvitationCode(enterpriseVo.getInvitationCode());
        if (null == enterpriseVo.getIsShare()){
            companyExtendVo.setDivedeStatus(0);
        }else {
            companyExtendVo.setDivedeStatus(Integer.parseInt(enterpriseVo.getIsShare()));
        }
        if (null != tyyCompanyExtendVo ){
            companyExtendVo.setWithdrawTotalCash(tyyCompanyExtendVo.getMoney());
        }
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setId(companyExtendVo.getId());
        CompanyExtendVo companyExtendVo1 = companyExtendDaoImpl.load(companyExtendGetReqVo,CompanyExtendVo.class);
        if (null == companyExtendVo1){
            companyExtendDaoImpl.create(companyExtendVo);
        }else{
            companyExtendDaoImpl.update(companyExtendVo);
        }

        /*保存银行卡表*/
        Boolean flag = true;
        for (EnterpriseBankVo enterpriseBankVo:enterpriseBankVoList) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            companyBankCardVo.setId(enterpriseBankVo.getId());
            companyBankCardVo.setName(enterpriseBankVo.getName());
            companyBankCardVo.setBankCardCode(enterpriseBankVo.getBanknum());
            companyBankCardVo.setBankName(enterpriseBankVo.getBankname());
            companyBankCardVo.setType(enterpriseBankVo.getType());
            companyBankCardVo.setCompanyId(enterpriseBankVo.getEnterpriseid());
            companyBankCardVo.setBankAddress(enterpriseBankVo.getAddr());
            companyBankCardVo.setPhone(enterpriseBankVo.getPhone());
            companyBankCardVo.setIdCard(enterpriseBankVo.getIdcard());
            companyBankCardVo.setBankCode(enterpriseBankVo.getUnionBank());
            companyBankCardVo.setStatus(enterpriseBankVo.getBankStatus());
            companyBankCardVo.setBindingCode(enterpriseBankVo.getBindId());
            companyBankCardVo.setBindingTime(enterpriseBankVo.getBindDate());
            if (flag){
                companyBankCardVo.setIsDefault(1);
                flag = false;
            }
            CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
            companyBankCardGetReqVo.setId(companyBankCardVo.getId());
            CompanyBankCardVo companyBankCardVo1 = companyBankCardDaoImpl.load(companyBankCardGetReqVo,CompanyBankCardVo.class);
            if (null == companyBankCardVo1){
                companyBankCardDaoImpl.create(companyBankCardVo);
            }else{
                companyBankCardDaoImpl.update(companyBankCardVo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrderStepThree(OrderStepThreeResVo reqVo) {
        TyyOrdersVo tyyOrdersVo = reqVo.getTyyOrdersVo();
        List<TyyOrderbackVo> tyyOrderbackVoList = reqVo.getTyyOrderbackVoList();
        TyyOrderdetailsVo tyyOrderdetailsVo = reqVo.getTyyOrderdetailsVo();
        TyyTouristVo tyyTouristVo = reqVo.getTyyTouristVo();
        OrderRelVo orderRelVo = reqVo.getOrderRelVo();
        /*OrderVo表*/
        if (null != tyyOrdersVo){
            saveOrderVoStepThree(tyyOrdersVo,tyyOrderbackVoList,orderRelVo);
        }

        /*OrderExtendVo表*/
        if (null != tyyOrdersVo){
            saveOrderExtendVoStepThree(tyyOrdersVo);
        }

        /*OrderRefundVo表*/
        if (null != tyyOrderbackVoList){
            saveOrderRefundVoStepThree(tyyOrderbackVoList);
        }

        /*OrderStatusVo表*/
        if (null != tyyOrdersVo){
            saveOrderStatusVoStepThree(tyyOrdersVo);
        }

        /*OrderTicketDetailVo表*/
        if (null != tyyOrderdetailsVo && null != tyyOrdersVo){
            saveOrderTicketDetailVoStepThree(tyyOrderdetailsVo,tyyOrdersVo);
        }

        /*OrderTouristVo表*/
        if (null != tyyTouristVo){
            saveOrderTouristVoStepThree(tyyTouristVo);
        }

        /*DiscountDetailVo表*/
        if (null != tyyOrdersVo){
            saveDiscountDetailVoStepThree(tyyOrdersVo);
        }
    }

    private void saveDiscountDetailVoStepThree(TyyOrdersVo tyyOrdersVo) {
        DiscountDetailVo discountDetailVo = new DiscountDetailVo();
        discountDetailVo.setId(StringHelper.getNewID());
        discountDetailVo.setOrder_id(tyyOrdersVo.getOrdersn());
        discountDetailVo.setDiscount_money(tyyOrdersVo.getDiscountprice());
        /*若该order_id存在则跳过,不存在则新增*/
        DiscountDetailGetReqVo discountDetailGetReqVo = new DiscountDetailGetReqVo();
        discountDetailGetReqVo.setOrder_id(discountDetailVo.getOrder_id());
        DiscountDetailVo discountDetailVo1 = discountDetailDao.load(discountDetailGetReqVo,DiscountDetailVo.class);
        if (null == discountDetailVo1){
            discountDetailDao.create(discountDetailVo);
        }
    }

    private void saveOrderTouristVoStepThree(TyyTouristVo tyyTouristVo) {
        OrderTouristVo orderTouristVo = new OrderTouristVo();
        orderTouristVo.setId(StringHelper.getNewID());
        orderTouristVo.setOrder_id(tyyTouristVo.getOrdersn());
        orderTouristVo.setName(tyyTouristVo.getName());
        orderTouristVo.setPhone(tyyTouristVo.getPhone());
        orderTouristVo.setCredential_type(tyyTouristVo.getCard_type());
        orderTouristVo.setCredential_number(tyyTouristVo.getIdcard());
        /*若该order_id存在则跳过,不存在则新增*/
        OrderTouristGetReqVo orderTouristGetReqVo = new OrderTouristGetReqVo();
        orderTouristGetReqVo.setOrder_id(orderTouristVo.getOrder_id());
        OrderTouristVo orderTouristVo1 = orderTouristDao.load(orderTouristGetReqVo,OrderTouristVo.class);
        if (null == orderTouristVo1){
            orderTouristDao.create(orderTouristVo);
        }
    }

    private void saveOrderTicketDetailVoStepThree(TyyOrderdetailsVo tyyOrderdetailsVo, TyyOrdersVo tyyOrdersVo) {
        OrderTicketDetailVo orderTicketDetailVo = new OrderTicketDetailVo();
        orderTicketDetailVo.setId(StringHelper.getNewID());
        orderTicketDetailVo.setVerify_code(tyyOrderdetailsVo.getAuxiliarycode());
        orderTicketDetailVo.setOrder_id(tyyOrdersVo.getOrdersn());
        if (null == tyyOrderdetailsVo.getCodestatus()){
            orderTicketDetailVo.setTicket_status(0);
        }else {
            orderTicketDetailVo.setTicket_status(Integer.parseInt(tyyOrderdetailsVo.getCodestatus()));
        }
        if ("1".equals(tyyOrderdetailsVo.getCodestatus())){
            orderTicketDetailVo.setTime(tyyOrderdetailsVo.getChecktime());
        }else if("2".equals(tyyOrderdetailsVo.getCodestatus())){
            orderTicketDetailVo.setTime(tyyOrderdetailsVo.getRefundtime());
        }
        orderTicketDetailVo.setTicket_code(tyyOrderdetailsVo.getLinkid());
        orderTicketDetailVo.setCode_url(tyyOrderdetailsVo.getPicUrl());
        /*若该order_id存在则跳过,不存在则新增*/
        OrderTicketDetailGetReqVo orderTicketDetailGetReqVo = new OrderTicketDetailGetReqVo();
        orderTicketDetailGetReqVo.setOrder_id(orderTicketDetailVo.getOrder_id());
        OrderTicketDetailVo orderTicketDetailVo1 = orderTicketDetailDao.load(orderTicketDetailGetReqVo,OrderTicketDetailVo.class);
        if (null == orderTicketDetailVo1){
            orderTicketDetailDao.create(orderTicketDetailVo);
        }
    }

    private void saveOrderStatusVoStepThree(TyyOrdersVo tyyOrdersVo) {
        OrderStatusVo orderStatusVo = new OrderStatusVo();
        orderStatusVo.setId(tyyOrdersVo.getOrdersn());
        if (null == tyyOrdersVo.getPaytype()){
            orderStatusVo.setPay_type(0);
        }else {
            orderStatusVo.setPay_type(Integer.parseInt(tyyOrdersVo.getPaytype()));
        }
        orderStatusVo.setPayment_time(tyyOrdersVo.getPaymenttime());
        if (null == tyyOrdersVo.getPaystatus()){
            orderStatusVo.setPayment_status(0);
        }else {
            orderStatusVo.setPayment_status(Integer.parseInt(tyyOrdersVo.getPaystatus()));
        }
        if ("1".equals(tyyOrdersVo.getStatus())){
            orderStatusVo.setOrder_status(2);
        }else if("3".equals(tyyOrdersVo.getStatus()) && "0".equals(tyyOrdersVo.getPaystatus())){
            orderStatusVo.setOrder_status(0);
        }else if("3".equals(tyyOrdersVo.getStatus()) && "1".equals(tyyOrdersVo.getPaystatus())){
            orderStatusVo.setOrder_status(1);
        }
        orderStatusVo.setThird_order_id(tyyOrdersVo.getPiaostorderid());
        orderStatusVo.setProduct_company_id(tyyOrdersVo.getEnterpriseid());
        orderStatusVo.setPayment_id(tyyOrdersVo.getTongl_third_ordersn());
        if ("N".equals(tyyOrdersVo.getEmancipated())){
            orderStatusVo.setIs_summarize(0);
        }else{
            orderStatusVo.setIs_summarize(1);
        }
        orderStatusVo.setSummarize_time(tyyOrdersVo.getEmancipated_date());
        if (null == tyyOrdersVo.getProfit_checked()){
            orderStatusVo.setDivide_status(0);
        }else{
            orderStatusVo.setDivide_status(Integer.parseInt(tyyOrdersVo.getProfit_checked()));
        }
        orderStatusVo.setDivide_time(tyyOrdersVo.getProfit_checked_date());
        orderStatusVo.setAgent_company_id(tyyOrdersVo.getFxsid());
        if (null == tyyOrdersVo.getIsdelete()){
            orderStatusVo.setIs_delete(0);
        }else {
            orderStatusVo.setIs_delete(Integer.parseInt(tyyOrdersVo.getIsdelete()));
        }
        orderStatusVo.setPay_tonglian_id(tyyOrdersVo.getTongl_ordersn());
        /*若该id存在则跳过,不存在则新增*/
        OrderStatusGetReqVo orderStatusGetReqVo = new OrderStatusGetReqVo();
        orderStatusGetReqVo.setId(orderStatusVo.getId());
        OrderStatusVo orderStatusVo1 = orderStatusDaoImpl.load(orderStatusGetReqVo,OrderStatusVo.class);
        if (null == orderStatusVo1){
            orderStatusDaoImpl.create(orderStatusVo);
        }
    }

    private void saveOrderRefundVoStepThree(List<TyyOrderbackVo> tyyOrderbackVoList) {
        for (TyyOrderbackVo tyyOrderbackVo:tyyOrderbackVoList) {
            OrderRefundVo orderRefundVo = new OrderRefundVo();
            orderRefundVo.setId(tyyOrderbackVo.getId());
            orderRefundVo.setOrder_id(tyyOrderbackVo.getOrdersn());
            orderRefundVo.setOperator(tyyOrderbackVo.getAcceptanceuser());
            orderRefundVo.setRefund_status(tyyOrderbackVo.getRefundstatus());
            orderRefundVo.setRefund_date(tyyOrderbackVo.getRefundtime());
            orderRefundVo.setRefund_fee(tyyOrderbackVo.getRefundFee());
            orderRefundVo.setRefund_amount(tyyOrderbackVo.getReceiveMoney());
            orderRefundVo.setRefund_reason(tyyOrderbackVo.getRefundReason());
            /*若该id存在则跳过,不存在则新增*/
            OrderRefundGetReqVo orderRefundGetReqVo = new OrderRefundGetReqVo();
            orderRefundGetReqVo.setId(orderRefundVo.getId());
            OrderRefundVo orderRefundVo1 = orderRefundDaoImpl.load(orderRefundGetReqVo,OrderRefundVo.class);
            if (null == orderRefundVo1){
                orderRefundDaoImpl.create(orderRefundVo);
            }
        }
    }

    private void saveOrderExtendVoStepThree(TyyOrdersVo tyyOrdersVo) {
        /*游玩地址*/
        OrderExtendVo orderExtendVoAddress = new OrderExtendVo();
        orderExtendVoAddress.setId(StringHelper.getNewID());
        orderExtendVoAddress.setOrder_id(tyyOrdersVo.getOrdersn());
        orderExtendVoAddress.setTitle("游玩地址");
        orderExtendVoAddress.setContent(tyyOrdersVo.getPlay_address());
        OrderExtendGetReqVo orderExtendGetReqVo = new OrderExtendGetReqVo();
        orderExtendGetReqVo.setOrder_id(orderExtendVoAddress.getOrder_id());
        orderExtendGetReqVo.setTitle(orderExtendVoAddress.getTitle());
        /*若该order_id存在则跳过,不存在则新增*/
        OrderExtendVo orderExtendVo1 = orderExtendDaoImpl.load(orderExtendGetReqVo,OrderExtendVo.class);
        if (null == orderExtendVo1){
            orderExtendDaoImpl.create(orderExtendVoAddress);
        }
        /*OrderExtendVo表*/
        /*游玩时间*/
        OrderExtendVo orderExtendVoTime = new OrderExtendVo();
        orderExtendVoTime.setId(StringHelper.getNewID());
        orderExtendVoTime.setOrder_id(tyyOrdersVo.getOrdersn());
        orderExtendVoTime.setTitle("游玩时间");
        orderExtendVoTime.setContent(tyyOrdersVo.getPlay_time());
        OrderExtendGetReqVo orderExtendGetReqVo1 = new OrderExtendGetReqVo();
        orderExtendGetReqVo1.setOrder_id(orderExtendVoTime.getOrder_id());
        orderExtendGetReqVo1.setTitle(orderExtendVoTime.getTitle());
        /*若该order_id存在则跳过,不存在则新增*/
        OrderExtendVo orderExtendVo2 = orderExtendDaoImpl.load(orderExtendGetReqVo,OrderExtendVo.class);
        if (null == orderExtendVo2){
            orderExtendDaoImpl.create(orderExtendVoTime);
        }
    }

    private void saveOrderVoStepThree(TyyOrdersVo tyyOrdersVo, List<TyyOrderbackVo> tyyOrderbackVoList, OrderRelVo orderRelVo) {
        int refundNum = 0;
        double refundFee = 0d;
        double pdRefundMoney = 0d;
        double refundMoney = 0d;
        for (TyyOrderbackVo tyyOrderbackVo:tyyOrderbackVoList) {
            if (null != tyyOrderbackVo){
                refundNum += tyyOrderbackVo.getRefundnum();
                refundFee += tyyOrderbackVo.getRefundFee();
                pdRefundMoney += tyyOrderbackVo.getReceiveMoney();
                refundMoney += tyyOrderbackVo.getRefundMoney();
            }
        }
        OrderVo orderVo = new OrderVo();
        if (null != orderRelVo){
            orderVo.setPid(orderRelVo.getGroup_ordersn());
        }
        orderVo.setId(tyyOrdersVo.getOrdersn());
        orderVo.setProduct_name(tyyOrdersVo.getConsignee());
        orderVo.setMerchant_name(tyyOrdersVo.getScenicspotname());
        orderVo.setProduct_code(tyyOrdersVo.getProductsn());
        orderVo.setRefund_num(refundNum);
        orderVo.setOrder_num(tyyOrdersVo.getBuynum());
        orderVo.setUnit_price(tyyOrdersVo.getPrice());
        orderVo.setTotal_money(tyyOrdersVo.getTotal());
        orderVo.setPlay_date(tyyOrdersVo.getTraveldate());
        orderVo.setOrder_time(tyyOrdersVo.getOrdertime());
        orderVo.setUser_id(tyyOrdersVo.getMemberid());
        orderVo.setTicket_phone(tyyOrdersVo.getUsertel());
        orderVo.setCost_price(tyyOrdersVo.getPurchaseprice());
        orderVo.setCost_total_money(tyyOrdersVo.getPurchaseprice()*tyyOrdersVo.getBuynum());
        if (null != tyyOrdersVo.getDiscountprice() && null != orderVo.getCost_total_money()){
            orderVo.setOrder_money(orderVo.getCost_total_money()-tyyOrdersVo.getDiscountprice());
        }
        orderVo.setRefund_fee(refundFee);
        orderVo.setPd_refund_money(pdRefundMoney);
        orderVo.setDiscount_money(tyyOrdersVo.getDiscountprice());
        orderVo.setPd_discount_money(tyyOrdersVo.getDiscountprice());
        orderVo.setRefund_money(refundMoney);
        if (null == tyyOrdersVo.getFieldTicket()){
            orderVo.setSub_order_type(0);
        }else {
            orderVo.setSub_order_type(Integer.parseInt(tyyOrdersVo.getFieldTicket()));
        }
        orderVo.setPd_order_money(tyyOrdersVo.getRealprice());
        orderVo.setArea_code(tyyOrdersVo.getSight_spot_code());
        orderVo.setOrder_type(1);
        /*若该id存在则跳过，不存在则新增*/
        OrderGetReqVo orderGetReqVo = new OrderGetReqVo();
        orderGetReqVo.setId(orderVo.getId());
        OrderVo orderVo1 = orderDaoImpl.load(orderGetReqVo,OrderVo.class);
        if (null == orderVo1){
            orderDaoImpl.create(orderVo);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrderStepOne(OrderStepOneResVo reqVo) {
        TyyOrderVo tyyOrderVo = reqVo.getTyyOrderVo();
        TyyOrderMixVo tyyOrderMixVo = reqVo.getTyyOrderMixVo();
        List<TyyOrderbackVo> tyyOrderbackVoList = reqVo.getTyyOrderbackVoList();
        TyyOrderdetailsVo tyyOrderdetailsVo = reqVo.getTyyOrderdetailsVo();
        TyyTouristVo tyyTouristVo = reqVo.getTyyTouristVo();

        /*pd_order*/
        if (null != tyyOrderVo || null != tyyOrderMixVo){
            saveOrderVoStepOne(tyyOrderVo,tyyOrderMixVo,tyyOrderbackVoList);
        }

        /*pd_order_status*/
        if (null != tyyOrderVo || null != tyyOrderMixVo){
            saveOrderStatusVoStepOne(tyyOrderVo,tyyOrderMixVo);
        }

        /*pd_order_extend*/
        if (null != tyyOrderVo || null != tyyOrderMixVo){
            saveOrderExtendVoStepOne(tyyOrderVo,tyyOrderMixVo);
        }

        /*pd_discount_detail*/
        if (null != tyyOrderVo || null != tyyOrderMixVo){
            saveDiscountDetailVoStepOne(tyyOrderVo,tyyOrderMixVo);
        }

        /*pd_order_ticket_detail*/
        if ((null != tyyOrderVo || null != tyyOrderMixVo) && null != tyyOrderdetailsVo){
            saveOrderTicketDetailVoStepOne(tyyOrderVo,tyyOrderMixVo,tyyOrderdetailsVo);
        }

        /*pd_order_refund*/
        if (null != tyyOrderbackVoList){
            saveOrderRefundVoStepOne(tyyOrderbackVoList);
        }

        /*OrderTouristVo表*/
        if (null != tyyTouristVo){
            saveOrderTouristVoStepOne(tyyTouristVo);
        }
    }

    private void saveOrderTouristVoStepOne(TyyTouristVo tyyTouristVo) {
        OrderTouristVo orderTouristVo = new OrderTouristVo();
        orderTouristVo.setId(StringHelper.getNewID());
        orderTouristVo.setOrder_id(tyyTouristVo.getOrdersn());
        orderTouristVo.setName(tyyTouristVo.getName());
        orderTouristVo.setPhone(tyyTouristVo.getPhone());
        orderTouristVo.setCredential_type(tyyTouristVo.getCard_type());
        orderTouristVo.setCredential_number(tyyTouristVo.getIdcard());
        /*若存在则修改，不存在则添加*/
        OrderTouristGetReqVo orderTouristGetReqVo = new OrderTouristGetReqVo();
        orderTouristGetReqVo.setOrder_id(tyyTouristVo.getOrdersn());
        OrderTouristVo orderTouristVo1 = orderTouristDao.load(orderTouristGetReqVo,OrderTouristVo.class);
        if (null == orderTouristVo1){
            orderTouristDao.create(orderTouristVo);
        }else {
            orderTouristVo.setId(orderTouristVo1.getId());
            orderTouristDao.update(orderTouristVo);
        }
    }

    private void saveOrderRefundVoStepOne(List<TyyOrderbackVo> tyyOrderbackVoList) {
        for (TyyOrderbackVo tyyOrderbackVo:tyyOrderbackVoList) {
            OrderRefundVo orderRefundVo = new OrderRefundVo();
            orderRefundVo.setId(tyyOrderbackVo.getId());
            orderRefundVo.setOrder_id(tyyOrderbackVo.getOrdersn());
            orderRefundVo.setOperator(tyyOrderbackVo.getAcceptanceuser());
            orderRefundVo.setRefund_status(tyyOrderbackVo.getRefundstatus());
            orderRefundVo.setRefund_date(tyyOrderbackVo.getRefundtime());
            orderRefundVo.setRefund_fee(tyyOrderbackVo.getRefundFee());
            orderRefundVo.setRefund_amount(tyyOrderbackVo.getReceiveMoney());
            orderRefundVo.setRefund_reason(tyyOrderbackVo.getRefundReason());
            /*若存在则修改，不存在则添加*/
            OrderRefundGetReqVo orderRefundGetReqVo = new OrderRefundGetReqVo();
            orderRefundGetReqVo.setId(tyyOrderbackVo.getId());
            OrderRefundVo orderRefundVo1 = orderRefundDaoImpl.load(orderRefundGetReqVo,OrderRefundVo.class);
            if (null == orderRefundVo1){
                orderRefundDaoImpl.create(orderRefundVo);
            }else{
                orderRefundDaoImpl.update(orderRefundVo);
            }
        }
    }

    private void saveOrderTicketDetailVoStepOne(TyyOrderVo tyyOrderVo, TyyOrderMixVo tyyOrderMixVo, TyyOrderdetailsVo tyyOrderdetailsVo) {
        OrderTicketDetailVo orderTicketDetailVo = new OrderTicketDetailVo();
        if (null != tyyOrderVo){
            orderTicketDetailVo.setOrder_id(tyyOrderVo.getId());
        }else if(null != tyyOrderMixVo){
            orderTicketDetailVo.setOrder_id(tyyOrderMixVo.getOrdersn());
        }
        orderTicketDetailVo.setId(StringHelper.getNewID());
        orderTicketDetailVo.setVerify_code(tyyOrderdetailsVo.getAuxiliarycode());
        if (null == tyyOrderdetailsVo.getCodestatus()){
            orderTicketDetailVo.setTicket_status(0);
        }else {
            orderTicketDetailVo.setTicket_status(Integer.parseInt(tyyOrderdetailsVo.getCodestatus()));
        }
        if (null != tyyOrderdetailsVo.getCodestatus()){
            if ("1".equals(tyyOrderdetailsVo.getCodestatus())){
                orderTicketDetailVo.setTime(tyyOrderdetailsVo.getChecktime());
            }else if("2".equals(tyyOrderdetailsVo.getCodestatus())){
                orderTicketDetailVo.setTime(tyyOrderdetailsVo.getRefundtime());
            }
        }
        orderTicketDetailVo.setTicket_code(tyyOrderdetailsVo.getLinkid());
        orderTicketDetailVo.setCode_url(tyyOrderdetailsVo.getPicUrl());
        /*若存在则修改，不存在则添加*/
        OrderTicketDetailGetReqVo orderTicketDetailGetReqVo = new OrderTicketDetailGetReqVo();
        orderTicketDetailGetReqVo.setOrder_id(orderTicketDetailVo.getOrder_id());
        OrderTicketDetailVo orderTicketDetailVo1 = orderTicketDetailDao.load(orderTicketDetailGetReqVo,OrderTicketDetailVo.class);
        if (null == orderTicketDetailVo1){
            orderTicketDetailDao.create(orderTicketDetailVo);
        }else {
            orderTicketDetailVo.setId(orderTicketDetailVo1.getId());
            orderTicketDetailDao.update(orderTicketDetailVo);
        }
    }

    private void saveDiscountDetailVoStepOne(TyyOrderVo tyyOrderVo, TyyOrderMixVo tyyOrderMixVo) {
        DiscountDetailVo discountDetailVo = new DiscountDetailVo();
        if (null != tyyOrderVo){
            discountDetailVo.setOrder_id(tyyOrderVo.getId());
            discountDetailVo.setDiscount_money(tyyOrderVo.getDiscount_price());
        }else if(null != tyyOrderMixVo){
            discountDetailVo.setOrder_id(tyyOrderMixVo.getOrdersn());
            discountDetailVo.setDiscount_money(tyyOrderMixVo.getDiscountprice());
        }
        discountDetailVo.setId(StringHelper.getNewID());
        /*若存在则修改，不存在则添加*/
        DiscountDetailGetReqVo discountDetailGetReqVo = new DiscountDetailGetReqVo();
        discountDetailGetReqVo.setOrder_id(discountDetailVo.getOrder_id());
        DiscountDetailVo discountDetailVo1 = discountDetailDao.load(discountDetailGetReqVo,DiscountDetailVo.class);
        if (null == discountDetailVo1){
            discountDetailDao.create(discountDetailVo);
        }else {
            discountDetailVo.setId(discountDetailVo1.getId());
            discountDetailDao.update(discountDetailVo);
        }
    }

    private void saveOrderExtendVoStepOne(TyyOrderVo tyyOrderVo, TyyOrderMixVo tyyOrderMixVo) {
        if (null != tyyOrderVo){
            OrderExtendVo orderExtendVo = new OrderExtendVo();
            orderExtendVo.setId(StringHelper.getNewID());
            orderExtendVo.setOrder_id(tyyOrderVo.getId());
            /*若存在则修改，不存在则添加*/
            OrderExtendGetReqVo orderExtendGetReqVo = new OrderExtendGetReqVo();
            orderExtendGetReqVo.setOrder_id(tyyOrderVo.getId());
            OrderExtendVo orderExtendVo1 = orderExtendDaoImpl.load(orderExtendGetReqVo,OrderExtendVo.class);
            if (null == orderExtendVo1){
                orderExtendDaoImpl.create(orderExtendVo);
            }else {
                orderExtendVo.setId(orderExtendVo1.getId());
                orderExtendDaoImpl.update(orderExtendVo);
            }

        }else if(null != tyyOrderMixVo){
            /*pd_order_extend游玩地址*/
            OrderExtendVo orderExtendAddress = new OrderExtendVo();
            orderExtendAddress.setId(StringHelper.getNewID());
            orderExtendAddress.setOrder_id(tyyOrderMixVo.getOrdersn());
            orderExtendAddress.setTitle("游玩地址");
            orderExtendAddress.setContent(tyyOrderMixVo.getPlay_address());
            /*若存在则修改，不存在则添加*/
            OrderExtendGetReqVo orderExtendGetReqVo = new OrderExtendGetReqVo();
            orderExtendGetReqVo.setOrder_id(tyyOrderMixVo.getOrdersn());
            orderExtendGetReqVo.setTitle(orderExtendAddress.getTitle());
            OrderExtendVo orderExtendAddress1 = orderExtendDaoImpl.load(orderExtendGetReqVo,OrderExtendVo.class);
            if (null == orderExtendAddress1){
                orderExtendDaoImpl.create(orderExtendAddress);
            }else {
                orderExtendAddress.setId(orderExtendAddress1.getId());
                orderExtendDaoImpl.update(orderExtendAddress);
            }
            /*pd_order_extend游玩时间*/
            OrderExtendVo orderExtendDate = new OrderExtendVo();
            orderExtendAddress.setId(StringHelper.getNewID());
            orderExtendDate.setOrder_id(tyyOrderMixVo.getOrdersn());
            orderExtendDate.setTitle("游玩时间");
            orderExtendDate.setContent(tyyOrderMixVo.getPlay_time());
            /*若存在则修改，不存在则添加*/
            OrderExtendGetReqVo orderExtendGetReqVo1 = new OrderExtendGetReqVo();
            orderExtendGetReqVo.setOrder_id(tyyOrderMixVo.getOrdersn());
            orderExtendGetReqVo.setTitle(orderExtendDate.getTitle());
            OrderExtendVo orderExtendDate1 = orderExtendDaoImpl.load(orderExtendGetReqVo1,OrderExtendVo.class);
            if (null == orderExtendDate1){
                orderExtendDaoImpl.create(orderExtendDate);
            }else{
                orderExtendDate.setId(orderExtendDate1.getId());
                orderExtendDaoImpl.update(orderExtendDate);
            }
        }
    }

    private void saveOrderStatusVoStepOne(TyyOrderVo tyyOrderVo, TyyOrderMixVo tyyOrderMixVo) {
        OrderStatusVo orderStatusVo = new OrderStatusVo();
        if (null != tyyOrderVo){
            orderStatusVo.setId(tyyOrderVo.getId());
            orderStatusVo.setAgent_company_id(tyyOrderVo.getSale_company_id());
            orderStatusVo.setProduct_company_id(tyyOrderVo.getProduct_company_id());
            orderStatusVo.setOrder_status(tyyOrderVo.getOrder_status());
            orderStatusVo.setPay_type(tyyOrderVo.getPay_type());
            orderStatusVo.setPay_third_id(tyyOrderVo.getPay_type_id());
            orderStatusVo.setPayment_time(tyyOrderVo.getPay_date());
            if (null != tyyOrderVo.getPay_status()){
                if (tyyOrderVo.getPay_status() == 0){
                    orderStatusVo.setPayment_status(0);
                }else{
                    orderStatusVo.setPayment_status(1);
                }
            }
            orderStatusVo.setPayment_id(tyyOrderVo.getTongl_third_ordersn());
            orderStatusVo.setPay_tonglian_id(tyyOrderVo.getTongl_ordersn());
        }else if(null != tyyOrderMixVo){
            orderStatusVo.setId(tyyOrderMixVo.getOrdersn());
            if (null == tyyOrderMixVo.getPaytype()){
                orderStatusVo.setPay_type(0);
            }else {
                orderStatusVo.setPay_type(Integer.parseInt(tyyOrderMixVo.getPaytype()));
            }
            orderStatusVo.setPayment_time(tyyOrderMixVo.getPaymenttime());
            if (null == tyyOrderMixVo.getPaystatus()){
                orderStatusVo.setPayment_status(0);
            }else {
                orderStatusVo.setPayment_status(Integer.parseInt(tyyOrderMixVo.getPaystatus()));
            }
            if (null == tyyOrderMixVo.getOrder_status()){
                orderStatusVo.setOrder_status(0);
            }else {
                orderStatusVo.setOrder_status(Integer.parseInt(tyyOrderMixVo.getOrder_status()));
            }
            orderStatusVo.setThird_order_id(tyyOrderMixVo.getPiaostorderid());
            if (null != tyyOrderMixVo.getEmancipated()){
                if ("N".equals(tyyOrderMixVo.getEmancipated())){
                    orderStatusVo.setIs_summarize(0);
                }else{
                    orderStatusVo.setIs_summarize(1);
                }
            }
            orderStatusVo.setSummarize_time(tyyOrderMixVo.getEmancipated_date());
            if (null == tyyOrderMixVo.getProfit_checked()){
                orderStatusVo.setDivide_status(0);
            }else {
                orderStatusVo.setDivide_status(Integer.parseInt(tyyOrderMixVo.getProfit_checked()));
            }
            orderStatusVo.setDivide_time(tyyOrderMixVo.getProfit_checked_date());
            orderStatusVo.setAgent_company_id(tyyOrderMixVo.getFxsid());
            if (null == tyyOrderMixVo.getIsdelete()){
                orderStatusVo.setIs_delete(0);
            }else {
                orderStatusVo.setIs_delete(Integer.parseInt(tyyOrderMixVo.getIsdelete()));
            }
            orderStatusVo.setPayment_id(tyyOrderMixVo.getTongl_third_ordersn());
            orderStatusVo.setPay_tonglian_id(tyyOrderMixVo.getTongl_ordersn());
            orderStatusVo.setPay_third_id(tyyOrderMixVo.getPay_type_id());
            orderStatusVo.setProduct_company_id(tyyOrderMixVo.getProduct_company_id());
        }
        /*若存在则修改，不存在则添加*/
        OrderStatusGetReqVo orderStatusGetReqVo = new OrderStatusGetReqVo();
        orderStatusGetReqVo.setId(orderStatusVo.getId());
        OrderStatusVo orderStatusVo1 = orderStatusDaoImpl.load(orderStatusGetReqVo,OrderStatusVo.class);
        if (null == orderStatusVo1){
            orderStatusDaoImpl.create(orderStatusVo);
        }else {
            orderStatusDaoImpl.update(orderStatusVo);
        }
    }

    private void saveOrderVoStepOne(TyyOrderVo tyyOrderVo, TyyOrderMixVo tyyOrderMixVo, List<TyyOrderbackVo> tyyOrderbackVoList) {
        OrderVo orderVo = new OrderVo();
        if (null != tyyOrderVo){
            orderVo.setId(tyyOrderVo.getId());
            orderVo.setPid(tyyOrderVo.getPid());
            orderVo.setOrder_type(tyyOrderVo.getOrder_type());
            orderVo.setSub_order_type(tyyOrderVo.getSub_order_type());
            orderVo.setProduct_name(tyyOrderVo.getProduct_name());
            orderVo.setPlay_date(tyyOrderVo.getPlay_date());
            orderVo.setUnit_price(tyyOrderVo.getPrice());
            orderVo.setOrder_num(tyyOrderVo.getOrder_num());
            orderVo.setTotal_money(tyyOrderVo.getSale_price());
            orderVo.setDiscount_money(tyyOrderVo.getDiscount_price());
            orderVo.setPd_discount_money(tyyOrderVo.getDiscount_price());
            orderVo.setPd_order_money(tyyOrderVo.getReal_price());
            orderVo.setCost_price(tyyOrderVo.getSettlement_price());
            orderVo.setCost_total_money(tyyOrderVo.getCost_price());
            if (null != orderVo.getCost_total_money() && null != tyyOrderVo.getDiscount_price()){
                orderVo.setOrder_money(orderVo.getCost_total_money()-tyyOrderVo.getDiscount_price());
            }
            orderVo.setOrder_fee(tyyOrderVo.getOrder_poundage_price());
            orderVo.setRefund_num(tyyOrderVo.getReturn_num());
            orderVo.setRefund_money(tyyOrderVo.getReturn_money());
            orderVo.setPd_refund_money(tyyOrderVo.getReturn_money());
            orderVo.setOrder_time(tyyOrderVo.getCreate_date());
        }else if(null != tyyOrderMixVo){
            orderVo.setId(tyyOrderMixVo.getOrdersn());
            orderVo.setProduct_name(tyyOrderMixVo.getConsignee());
            orderVo.setMerchant_name(tyyOrderMixVo.getScenicspotname());
            orderVo.setProduct_code(tyyOrderMixVo.getProductsn());
            orderVo.setOrder_num(tyyOrderMixVo.getBuynum());
            orderVo.setUnit_price(tyyOrderMixVo.getPrice());
            orderVo.setTotal_money(tyyOrderMixVo.getTotal());
            orderVo.setPlay_date(tyyOrderMixVo.getTraveldate());
            orderVo.setUser_id(tyyOrderMixVo.getMemberid());
            orderVo.setTicket_phone(tyyOrderMixVo.getUsertel());
            orderVo.setOrder_time(tyyOrderMixVo.getOrdertime());
            orderVo.setCost_price(tyyOrderMixVo.getPurchaseprice());
            orderVo.setCost_total_money(orderVo.getCost_price()*orderVo.getOrder_num());
            if (null != orderVo.getCost_total_money() && null != tyyOrderMixVo.getDiscountprice()){
                orderVo.setOrder_money(orderVo.getCost_total_money()-tyyOrderMixVo.getDiscountprice());
            }
            if (null == tyyOrderMixVo.getSub_order_type()){
                orderVo.setSub_order_type(0);
            }else {
                orderVo.setSub_order_type(Integer.parseInt(tyyOrderMixVo.getSub_order_type()));
            }
            orderVo.setPd_order_money(tyyOrderMixVo.getRealprice());
            orderVo.setPd_discount_money(tyyOrderMixVo.getDiscountprice());
            orderVo.setDiscount_money(tyyOrderMixVo.getDiscountprice());
            orderVo.setArea_code(tyyOrderMixVo.getSight_spot_code());
            orderVo.setPid(tyyOrderMixVo.getPid());
            orderVo.setOrder_type(tyyOrderMixVo.getOrder_type());
            orderVo.setRefund_num(tyyOrderMixVo.getReturn_num());
            orderVo.setPd_refund_money(tyyOrderMixVo.getReturn_money());
            orderVo.setRefund_money(tyyOrderMixVo.getReturn_money());
            orderVo.setOrder_fee(tyyOrderMixVo.getOrder_poundage_price());
        }
        double refundFee = 0d;
        for (TyyOrderbackVo tyyOrderbackVo:tyyOrderbackVoList) {
            if (null != tyyOrderbackVo){
                refundFee += tyyOrderbackVo.getRefundFee();
            }
        }
        orderVo.setRefund_fee(refundFee);
        /*若存在则修改，不存在则添加*/
        OrderGetReqVo orderGetReqVo = new OrderGetReqVo();
        orderGetReqVo.setId(orderVo.getId());
        OrderVo orderVo1 = orderDaoImpl.load(orderGetReqVo,OrderVo.class);
        if (null == orderVo1){
            orderDaoImpl.create(orderVo);
        }else{
            orderDaoImpl.update(orderVo);
        }
    }


}
