package com.pangding.web.authority.feign;

import com.pangding.web.authority.vo.reqvo.CompanyBankReqVo;
import com.pangding.web.authority.vo.reqvo.CompanyReqVo;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @Author zhangjinyao
 * @create 2019/6/2 18:06
 */
@FeignClient(value="pd-interface-pay")
@RequestMapping(value="/userNew")
public interface PayFeign {
    /**
     * 注册会员
     * @param req
     * @return
     */
    @RequestMapping(value="/register")
    public ResponseResult<CompanyReqVo> setCompanyInfo(@RequestBody CompanyReqVo req);

    /**
     * 绑定银行卡
     * @param req
     * @return
     */
    @RequestMapping(value="/bindback")
    public ResponseResult<CompanyBankReqVo> bindBack(@RequestBody CompanyBankReqVo req);

    /**
     * 解绑银行卡
     * @param req
     * @return
     */
    @RequestMapping(value = "/unbindBankCard")
    public ResponseResult<CompanyBankReqVo> unbindBankCard(@RequestBody CompanyBankReqVo req);

    /**
     * 获取签约地址
     * @param req
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/sign")
    ResponseResult<CompanyReqVo> sign(@RequestBody CompanyReqVo req) throws IOException;
}
