package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.WechatUserDao;
import com.pangding.web.authority.vo.WechatUserVo;
import com.pangding.web.authority.vo.reqvo.WechatUserGetReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.MapRow;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/29 17:13
 */
@Component
public class WechatUserDaoImpl extends BaseDaoImpl implements WechatUserDao {

    private static final String GET_USER_NUM_BY_MONTH = "GET_USER_NUM_BY_MONTH";
    @Override
    protected void init() {

        register(WechatUserVo.class);

        table.add(GET_USER_NUM_BY_MONTH,"select count(id) as num from pd_wechat_user where 1=1 ")
                .add("companyId","and company_id = ? ")
                .add("start","and follow_time >= ? ")
                .add("end","and follow_time < ? ");
    }

    @Override
    public Object getUserNumByMonth(WechatUserGetReqVo getReqVo) {
        return this.query(GET_USER_NUM_BY_MONTH,getReqVo);
    }
}
