package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyBankCardDao;
import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.dao.CompanyExtendDao;
import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.feign.DataFeign;
import com.pangding.web.authority.service.DataService;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.FindResVo;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author zhangjinyao
 * @create 2019/6/12 15:45
 */
@Service
public class DataServiceImpl implements DataService {
    @Autowired
    private CompanyDao companyDaoImpl;
    @Autowired
    private UserDao userDaoImpl;
    @Autowired
    private CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    private CompanyBankCardDao companyBankCardDaoImpl;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(FindResVo reqVo) {

        TyyCompanyVo tyyCompanyVo = reqVo.getTyyCompanyVo();
        TyyCompanyExtendVo tyyCompanyExtendVo = reqVo.getTyyCompanyExtendVo();
        EnterpriseVo enterpriseVo = reqVo.getEnterpriseVo();
        List<EnterpriseBankVo> enterpriseBankVoList = reqVo.getEnterpriseBankVoList();

        /*保存公司主表*/
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(tyyCompanyVo.getId());
        companyVo.setPid(tyyCompanyVo.getPid());
        companyVo.setInvitationCompanyId(tyyCompanyVo.getInvatationId());
        companyVo.setNature(tyyCompanyVo.getCompanyType());
        if (tyyCompanyVo.getCompanyType() == 1 || tyyCompanyVo.getCompanyType() == 2){
            companyVo.setCompanyType(1);
        }else if (tyyCompanyVo.getCompanyType() == 3){
            companyVo.setCompanyType(0);
        }
        companyVo.setCompanyName(tyyCompanyVo.getCompanyName());
        companyVo.setAddress(tyyCompanyVo.getCompanyAddress());
        companyVo.setBusinessLicenseCode(tyyCompanyVo.getCompanyCardNo());
        companyVo.setContactName(tyyCompanyVo.getContactName());
        companyVo.setContactCode(tyyCompanyVo.getContactNo());
        companyVo.setContactPhone(tyyCompanyVo.getContactTel());
        companyVo.setStatus(tyyCompanyVo.getStatus());
        companyVo.setCreateTime(tyyCompanyVo.getCreateTime());
        companyVo.setExamineStatus(Integer.parseInt(enterpriseVo.getExamine()));
        companyVo.setCompanyAttribute(Integer.parseInt(enterpriseVo.getUsertype()));
        if (null != tyyCompanyExtendVo ){
            companyVo.setElectromicAgreementCode(tyyCompanyExtendVo.getCode());
            companyVo.setSigningStatus(tyyCompanyExtendVo.getStatus());
        }
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(companyVo.getId());
        CompanyVo companyVo1 = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        if (null == companyVo1){
            companyDaoImpl.create(companyVo);
        }

        /*保存用户表*/
        UserVo userVo = new UserVo();
        userVo.setId(StringHelper.getNewID());
        userVo.setCompanyId(enterpriseVo.getId());
        userVo.setAccount(enterpriseVo.getAccount());
        userVo.setPassword(enterpriseVo.getPasswd());
        userVo.setRemark(enterpriseVo.getPlainPassword());
        userVo.setName(tyyCompanyVo.getContactName());
        userVo.setPhone(tyyCompanyVo.getContactTel());
        userVo.setCreateTime(tyyCompanyVo.getCreateTime());
        userVo.setEmail(enterpriseVo.getEmail());
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setAccount(userVo.getAccount());
        UserVo userVo1 = userDaoImpl.load(userGetReqVo,UserVo.class);
        if (null == userVo1){
            userDaoImpl.create(userVo);
        }

        /*保存公司扩展表*/
        CompanyExtendVo companyExtendVo = new CompanyExtendVo();
        companyExtendVo.setId(tyyCompanyVo.getId());
        companyExtendVo.setQrCodeUrl(enterpriseVo.getQrcodepath());
        companyExtendVo.setQrCode(enterpriseVo.getQrcodesrc());
        companyExtendVo.setInvitationCode(enterpriseVo.getInvitationCode());
        companyExtendVo.setDivedeStatus(Integer.parseInt(enterpriseVo.getIsShare()));
        if (null != tyyCompanyExtendVo ){
            companyExtendVo.setWithdrawTotalCash(tyyCompanyExtendVo.getMoney());
        }
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setId(companyExtendVo.getId());
        CompanyExtendVo companyExtendVo1 = companyExtendDaoImpl.load(companyExtendGetReqVo,CompanyExtendVo.class);
        if (null == companyExtendVo1){
            companyExtendDaoImpl.create(companyExtendVo);
        }

        /*保存银行卡表*/
        for (EnterpriseBankVo enterpriseBankVo:enterpriseBankVoList) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            companyBankCardVo.setId(enterpriseBankVo.getId());
            companyBankCardVo.setName(enterpriseBankVo.getName());
            companyBankCardVo.setBankCardCode(enterpriseBankVo.getBanknum());
            companyBankCardVo.setBankName(enterpriseBankVo.getBankname());
            companyBankCardVo.setType(enterpriseBankVo.getType());
            companyBankCardVo.setCompanyId(enterpriseBankVo.getEnterpriseid());
            companyBankCardVo.setBankAddress(enterpriseBankVo.getAddr());
            companyBankCardVo.setPhone(enterpriseBankVo.getPhone());
            companyBankCardVo.setIdCard(enterpriseBankVo.getIdcard());
            companyBankCardVo.setBankCode(enterpriseBankVo.getUnionBank());
            companyBankCardVo.setStatus(enterpriseBankVo.getBankStatus());
            companyBankCardVo.setBindingCode(enterpriseBankVo.getBindId());
            companyBankCardVo.setBindingTime(enterpriseBankVo.getBindDate());
            CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
            companyBankCardGetReqVo.setId(companyBankCardVo.getId());
            CompanyBankCardVo companyBankCardVo1 = companyBankCardDaoImpl.load(companyBankCardGetReqVo,CompanyBankCardVo.class);
            if (null == companyBankCardVo1){
                companyBankCardDaoImpl.create(companyBankCardVo);
            }
        }
    }
}
