package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyMsgDao;
import com.pangding.web.authority.vo.reqvo.CompanyMsgReqVo;
import com.pangding.web.authority.vo.resvo.GetCompanyMsgResVo;
import com.pangding.web.vo.system.pd.CompanyMsgVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CompanyMsgDaoImpl extends BaseDaoImpl implements CompanyMsgDao {

    private static final String QUERY_LIST = "QUERY_LIST";

    @Override
    protected void init() {

        register(CompanyMsgVo.class);

        table.add(QUERY_LIST, "select m.*,cm.company_id,cm.type " +
                "from pd_company_msg cm left join pd_msg m on cm.msg_id = m.id where 1=1 ")
                .add("companyId", "and cm.company_id = ? ")
                .add("type", "and cm.type = ? ");

    }

    @Override
    public List<GetCompanyMsgResVo> findCompanyMsgList(CompanyMsgReqVo req) {
        return this.query(GetCompanyMsgResVo.class, QUERY_LIST, req);
    }

}
