package com.pangding.web.authority.mq;

import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.constant.MqConstant;
import com.pangding.web.mq.CompanyProducer;
import com.pangding.web.vo.order.req.CapitalFlowReqVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyUpdateReqVo;
import com.rabbitmq.client.Channel;
import com.yanzuoguang.mq.service.MqService;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyConsumer {

    private static final Logger log = LoggerFactory.getLogger(CompanyConsumer.class);

    @Autowired
    private CompanyProducer companyProducer;
    @Autowired
    private MqService mqService;
    @Autowired
    private CompanyService companyService;


    /**
     * 初始化mq
     */
    public void init() {
        companyProducer.init();
    }

    /**
     * 申请提现
     * @param capitalFlowReqVo
     */
    public void applyWithdrawal(CapitalFlowReqVo capitalFlowReqVo){
        companyProducer.applyWithdrawal(capitalFlowReqVo);
    }

    @RabbitListener(queues = {MqConstant.COMPANY_MONEY_UPDATE})
    public void UpdateCompanyMoney(String content, Message message, Channel channel) {
        log.info("[UpdateCompanyMoney 监听的消息] - [消费时间] - [{}] - [{}]", DateHelper.getNow(), content);
        try {
            CompanyMoneyUpdateReqVo companyMoneyUpdateReqVo = JsonHelper.deserialize(content, CompanyMoneyUpdateReqVo.class);
            companyService.updateCompanyMoney(companyMoneyUpdateReqVo);
        } catch (Exception e) {
            Log.error(CompanyConsumer.class, e);
        } finally {
            mqService.basicAck(message, channel);
        }
    }


//    @RabbitListener(queues = {MqConstant.COMPANY_MONEY_UPDATE})
//    public void UpdateCompanyMoney(String content, Message message, Channel channel) {
//        log.info("[UpdateCompanyMoney 监听的消息] - [消费时间] - [{}] - [{}]", DateHelper.getNow(), content);
//        try {
//            CompanyMoneyUpdateReqVo companyMoneyUpdateReqVo = JsonHelper.deserialize(content, CompanyMoneyUpdateReqVo.class);
//            companyService.updateCompanyMoney(companyMoneyUpdateReqVo);
//        } catch (Exception e) {
//            Log.error(CompanyConsumer.class, e);
//        } finally {
//            mqService.basicAck(message, channel);
//        }
//    }

}
