package com.tcm.common.service.impl;

import com.tcm.common.dao.FloorAreaDao;
import com.tcm.common.dao.FloorDao;
import com.tcm.common.service.AreaService;
import com.tcm.util.area.FloorVo;
import com.tcm.util.area.req.FloorLoadPageReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.FloorResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class AreaServiceImpl implements AreaService {

    private final FloorDao floorDao;
    private final FloorAreaDao floorAreaDao;

    public AreaServiceImpl(FloorDao floorDao, FloorAreaDao floorAreaDao) {
        this.floorDao = floorDao;
        this.floorAreaDao = floorAreaDao;
    }

    @Override
    public String save(FloorReqVo req) {
        if (StringHelper.isEmpty(req.getFloorId())) {
            FloorVo floor = new FloorVo();
            String floorId = StringHelper.getNewID();
            floor.setFloorId(floorId);
            ObjectHelper.writeWithFrom(floor, req);
            floor.setCreateTime(DateHelper.getNow());
            floorDao.save(floor);
            return floorId;
        } else {
            FloorVo floor = new FloorVo();
            floor.setFloorId(req.getFloorId());
            FloorVo load = floorDao.load(floor, FloorVo.class);
            ObjectHelper.writeWithFrom(load, req);
            floorDao.update(load);
            return req.getFloorId();
        }
    }

    @Override
    public FloorResVo load(FloorReqVo req) {
        FloorVo floor = new FloorVo();
        floor.setFloorId(req.getFloorId());
        FloorResVo load = floorDao.load(floor, FloorResVo.class);
        return load;
    }

    @Override
    public PageSizeData<FloorResVo> loadPage(FloorLoadPageReqVo req) {
        PageSizeData<FloorResVo> page = floorDao.loadPage(req, FloorResVo.class);
        return page;
    }

    @Override
    public String remove(FloorReqVo req) {
        FloorVo floor = new FloorVo();
        floor.setFloorId(req.getFloorId());
        floorDao.remove(floor);
        return req.getFloorId();
    }
}
