package com.tcm.common.web;

import com.tcm.common.service.AreaService;
import com.tcm.util.area.req.FloorLoadPageReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.FloorResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/area")
public class AreaController {

    private final AreaService areaService;

    public AreaController(AreaService areaService) {
        this.areaService = areaService;
    }

    /**
     * 区域新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody FloorReqVo req) {
        return ResponseResult.result(areaService.save(req));

    }

    /**
     * 区域加载
     */
    @RequestMapping("/load")
    public ResponseResult<FloorResVo> load(@RequestBody FloorReqVo req) {
        return ResponseResult.result(areaService.load(req));

    }

    /**
     * 区域分页查询
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<FloorResVo>> loadPage(@RequestBody FloorLoadPageReqVo req) {
        return ResponseResult.result(areaService.loadPage(req));

    }

    /**
     * 区域删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody FloorReqVo req) {
        return ResponseResult.result(areaService.remove(req));

    }
}
