package com.tcm.common.web;

import com.tcm.common.service.ImageService;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.res.ImageResVo;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/image")
public class ImageController {


    private final ImageService imageService;

    public ImageController(ImageService imageService) {
        this.imageService = imageService;
    }

    /**
     * 图片新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody ImageReqVo req) {
        return ResponseResult.result(imageService.save(req));

    }

    /**
     * 图片加载
     */
    @RequestMapping("/load")
    public ResponseResult<ImageResVo> load(@RequestBody ImageReqVo req) {
        return ResponseResult.result(imageService.load(req));
    }

    /**
     * 图片删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody ImageReqVo req) {
        return ResponseResult.result(imageService.remove(req));
    }
    /**
     * 首页图片加载
     */
    @RequestMapping("/homeBanner")
    public ResponseResult<List<ImageResVo>> homeBanner(@RequestBody ImageReqVo req) {
        return ResponseResult.result(imageService.homeBanner(req));
    }
}
