package com.tcm.product.dao.impl;

import com.tcm.product.dao.ProductDao;
import com.tcm.util.product.ProductVo;
import com.tcm.util.product.req.ProductReqVo;
import com.tcm.util.product.res.ProductResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ProductDaoImpl extends BaseDaoImpl implements ProductDao {

    private static final String SQL_PRODUCT_LOAD_INFO = "product_load_info";

    @Override
    protected void init() {
        register(ProductVo.class);
        table.add(SQL_PRODUCT_LOAD_INFO, "select * from tcm_product as p " +
                "left join tcm_product_extend as pe on p.product_id = pe.product_id where 1=1 {WHERE} order by p.sort ")
                .add("productId", "p.product_id = ?")
                .add("categoryId", "p.category_id =?")
        ;
    }

    @Override
    public List<ProductResVo> loadInfoList(ProductReqVo req) {
        return query(ProductResVo.class, SQL_PRODUCT_LOAD_INFO, req);
    }
}
