package com.tcm.product.service;

import com.tcm.util.product.req.ProductLoadPageReqVo;
import com.tcm.util.product.req.ProductReqVo;
import com.tcm.util.product.res.ProductResVo;
import com.yanzuoguang.util.vo.PageSizeData;

public interface ProductService {
    /**
     * 产品保存
     *
     * @param req
     * @return
     */
    String save(ProductReqVo req);

    /**
     * 产品加载
     *
     * @param req
     * @return
     */
    ProductResVo load(ProductReqVo req);

    /**
     * 产品分页
     *
     * @param req
     * @return
     */
    PageSizeData<ProductResVo> loadPage(ProductLoadPageReqVo req);

    /**
     * 产品删除
     *
     * @param req
     * @return
     */
    String remove(ProductReqVo req);

    /**
     * 客户端产品列表
     * @param req
     * @return
     */
    PageSizeData<ProductResVo> displayList(ProductLoadPageReqVo req);
}
