package com.tcm.product.service.impl;

import com.tcm.product.dao.ProductCategoryDao;
import com.tcm.product.dao.ProductDao;
import com.tcm.product.dao.ProductExtendDao;
import com.tcm.product.service.ProductCategoryService;
import com.tcm.util.product.ProductCategoryVo;
import com.tcm.util.product.ProductExtendVo;
import com.tcm.util.product.req.ProductCategoryLoadPageReqVo;
import com.tcm.util.product.req.ProductCategoryReqVo;
import com.tcm.util.product.req.ProductReqVo;
import com.tcm.util.product.res.ProductCategoryResVo;
import com.tcm.util.product.res.ProductResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.MapHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class ProductCategoryServiceImpl implements ProductCategoryService {

    private final ProductCategoryDao productCategoryDao;
    private final ProductDao productDao;
    private final ProductExtendDao productExtendDao;

    public ProductCategoryServiceImpl(ProductCategoryDao productCategoryDao,
                                      ProductDao productDao,
                                      ProductExtendDao productExtendDao) {
        this.productCategoryDao = productCategoryDao;
        this.productDao = productDao;
        this.productExtendDao = productExtendDao;
    }

    @Override
    public String save(ProductCategoryReqVo req) {
        if (StringHelper.isEmpty(req.getCategoryId())) {
            //新增
            ProductCategoryVo productCategoryVo = new ProductCategoryVo();
            String categoryId = StringHelper.getNewID();
            ObjectHelper.writeWithFrom(productCategoryVo, req);
            productCategoryVo.setCategoryId(categoryId);
            productCategoryVo.setCreateTime(DateHelper.getNow());
            productCategoryDao.save(productCategoryVo);
            return categoryId;
        } else {
            ProductCategoryVo productCategoryVo = new ProductCategoryVo();
            productCategoryVo.setCategoryId(req.getCategoryId());
            ProductCategoryVo load = productCategoryDao.load(productCategoryVo, ProductCategoryVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            productCategoryDao.update(load);
            return req.getCategoryId();
        }
    }

    @Override
    public ProductCategoryResVo load(ProductCategoryReqVo req) {
        ProductCategoryVo productCategoryVo = new ProductCategoryVo();
        productCategoryVo.setCategoryId(req.getCategoryId());
        ProductCategoryResVo load = productCategoryDao.load(productCategoryVo, ProductCategoryResVo.class);
        return load;
    }

    @Override
    public PageSizeData<ProductCategoryResVo> loadPage(ProductCategoryLoadPageReqVo req) {
        PageSizeData<ProductCategoryResVo> page = productCategoryDao.loadPage(req, ProductCategoryResVo.class);
        return page;
    }

    @Override
    public String remove(ProductCategoryReqVo req) {
        ProductCategoryVo productCategoryVo = new ProductCategoryVo();
        productCategoryVo.setCategoryId(req.getCategoryId());
        productCategoryDao.remove(productCategoryVo);
        productDao.remove(productCategoryVo);
        return req.getCategoryId();
    }

    @Override
    public PageSizeData<ProductCategoryResVo> categoryProductPage(ProductCategoryLoadPageReqVo req) {
        PageSizeData<ProductCategoryResVo> page = productCategoryDao.loadPage(req, ProductCategoryResVo.class);
        List<ProductExtendVo> productExtendList = productExtendDao.loadList(req, ProductExtendVo.class);
        Map<String, ProductExtendVo> productExtendVoMap = MapHelper.getMap(productExtendList, ProductExtendVo::getProductId);
        page.getList().forEach(item -> {
            ProductReqVo productVo = new ProductReqVo();
            productVo.setCategoryId(item.getCategoryId());
            List<ProductResVo> loadList = productDao.loadInfoList(productVo);
            loadList.forEach(product -> {
                ProductExtendVo productExtendVo = productExtendVoMap.get(product.getProductId());
                if (productExtendVo != null) {
                    product.setProductExtendVo(productExtendVo);
                }
            });
            item.setProductList(loadList);
        });
        return page;
    }
}
