package com.pangding.web;

import com.alicp.jetcache.anno.config.EnableCreateCacheAnnotation;
import com.alicp.jetcache.anno.config.EnableMethodCache;
import com.yanzuoguang.util.helper.YzgLanguage;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * 日志自动启动服务
 * @author Administrator
 */
@SpringBootApplication(scanBasePackages = {
        "com.pangding.*",
        "com.yanzuoguang.*",
        "org.springframework.jdbc.*"
})
@EnableEurekaClient
@EnableFeignClients(basePackages={
        "com.pangding.*",
        "com.yanzuoguang.*"
})
@EnableMethodCache(basePackages = {
        "com.pangding.*",
        "com.tourbida",
        "com.yanzuoguang"
})
@EnableCreateCacheAnnotation
@EnableScheduling
@EnableCaching
@EnableAsync
public class UserApp implements CommandLineRunner{

    public static void main(String[] args) {
        SpringApplication.run(UserApp.class, args);
    }

    @Override
    public void run(String... args) throws Exception {
        YzgLanguage.get().setDefaultLanguage(YzgLanguage.LANGUAGE_CH);
    }
}