package com.pangding.web.authority.dao.company;

import com.pangding.web.authority.vo.reqvo.CompanyBankCardSetNotDefaultReqVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.pangding.web.vo.system.res.company.CompanyBankCardResVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/16 19:17
 */
public interface CompanyBankCardDao extends BaseDao {
    /**
     * 获取银行卡列表分页数据
     * @param reqVo
     * @return
     */
    PageSizeData<CompanyBankCardResVo> getBankCardListPage(CompanyBankCardReqVo reqVo);

    /**
     * 获取银行卡列表
     * @param req
     * @return
     */
    List<CompanyBankCardResVo> getBankCardList(CompanyBankCardReqVo req);

    /**
     * 将指定银行卡设置为非默认
     * @param req 设置非默认的请求对象
     */
    void updateDefault(CompanyBankCardReqVo req);
}
