package com.pangding.web.authority.feign;

import com.pangding.web.authority.vo.reqvo.CompanyScenicInfoReqVo;
import com.pangding.web.authority.vo.reqvo.MerchantCreateReqVo;
import com.pangding.web.vo.product.pd.merchant.MerchantVo;
import com.pangding.web.vo.v2.scenic.merchant.pd.MerchantDeviceVo;
import com.pangding.web.vo.v2.scenic.merchant.req.MerchantDeviceReqVo;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @Author zhangjinyao
 * @create 2019/5/22 11:55
 */
@FeignClient(value = "pd-scenic")
public interface StoreFeign {
    /**
     * 新建景区
     * @param req
     * @return
     */
    @RequestMapping("/scenic/merchantCreate")
    ResponseResult<MerchantVo> merchantCreate(@RequestBody MerchantCreateReqVo req);

    /**
     * 通过公司还是id获取商户信息
     *
     * @param req
     * @return
     */
    @RequestMapping("/scenic/getCompanyScenicInfo")
    ResponseResult<MerchantVo> getCompanyScenicInfo(@RequestBody CompanyScenicInfoReqVo req);


}
