package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.AgreementTemplateDao;
import com.pangding.web.authority.service.AgreementService;
import com.pangding.web.vo.system.pd.AgreementTemplateVo;
import com.pangding.web.vo.system.req.AgreementTemplateReqVo;
import com.pangding.web.vo.system.res.AgreementTemplateResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
public class AgreementServiceImpl implements AgreementService {

    private AgreementTemplateDao agreementTemplateDao;

    public AgreementServiceImpl(AgreementTemplateDao agreementTemplateDao) {
        this.agreementTemplateDao = agreementTemplateDao;
    }

    @Override
    public AgreementTemplateResVo findAgreementDetail(AgreementTemplateReqVo req) {
        AgreementTemplateResVo agreementTemplateResVo = agreementTemplateDao.load(req, AgreementTemplateResVo.class);
        return agreementTemplateResVo;
    }

    @Override
    public PageSizeData<AgreementTemplateResVo> findAgreemnetList(AgreementTemplateReqVo req) {
        PageSizeData<AgreementTemplateResVo> agreementTemplateResVoPageSizeData = agreementTemplateDao.loadPage(req, AgreementTemplateResVo.class);
        return agreementTemplateResVoPageSizeData;
    }

    @Override
    public AgreementTemplateVo saveAgreement(AgreementTemplateReqVo req){
        AgreementTemplateVo agreementTemplateVo = new AgreementTemplateVo();
        if(StringHelper.isEmpty(req.getAgreementId())){
            // 保存
            ObjectHelper.writeWithFrom(agreementTemplateVo, req);
            agreementTemplateVo.setCreateTime(DateHelper.getNow());
            agreementTemplateVo.setAgreementId(StringHelper.getNewID());
            agreementTemplateVo.setAgreementCode(agreementTemplateVo.getAgreementId());
            agreementTemplateDao.create(agreementTemplateVo);
        }else{
            // 修改
             agreementTemplateVo = agreementTemplateDao.load(req.getAgreementId(), AgreementTemplateVo.class);
            if(!StringHelper.isEmpty(agreementTemplateVo)){
                ObjectHelper.writeWithFrom(agreementTemplateVo, req);
                agreementTemplateDao.update(agreementTemplateVo);
            }
        }
        return agreementTemplateVo;
    }

    public void removeAgreement(AgreementTemplateReqVo req){
        agreementTemplateDao.remove(req.getAgreementId());
    }

}
