package com.pangding.web.authority.vo.code;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.CreateCache;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.pangding.web.cache.CacheName;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Component;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 验证码服务
 */
@Component
public class CodeService {

    private final DefaultKaptcha defaultKaptcha;
    private final PdDebugConfig pdDebugConfig;


    @CreateCache(name = CacheName.USER_PASSWORD_CODE, cacheType = CacheType.REMOTE, expire = 60, timeUnit = TimeUnit.MINUTES)
    private Cache<String, String> cache;

    public CodeService(DefaultKaptcha defaultKaptcha, PdDebugConfig pdDebugConfig) {
        this.defaultKaptcha = defaultKaptcha;
        this.pdDebugConfig = pdDebugConfig;
    }


    /**
     * 生成验证码
     *
     * @return 验证码效果
     */
    public CodeVo getCode() {
        // 生成文字验证码
        String text = defaultKaptcha.createText();
        // 生成图片验证码
        BufferedImage image = defaultKaptcha.createImage(text);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write(image, "jpg", out);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        // 对字节组Base64编码
        String img = Base64.getEncoder().encodeToString(out.toByteArray());
        CodeVo code = new CodeVo(StringHelper.getNewID(), img);
        if (pdDebugConfig.isDebug()) {
            code.setCode(text);
        }
        // 验证验证码文字
        cache.put(code.getId(), text);
        return code;
    }

    public void validate(String codeId, String codeValue, boolean validate) {
        if (!validate) {
            return;
        }
        if (StringHelper.isEmpty(codeId)) {
            throw new CodeException("验证码不能为空");
        }
        String text = cache.get(codeId);
        if (StringHelper.isEmpty(text)) {
            throw new CodeException("验证码失效");
        }
        cache.remove(codeId);
        if (StringHelper.compare(text, codeValue, true)) {
            return;
        }
        throw new CodeException("验证码错误");
    }

    public void validate(String codeId, String codeValue, List<String> names) {
        boolean validate = false;
        for (String name : names) {
            if (!StringHelper.isEmpty(name)) {
                validate = true;
                break;
            }
        }
        this.validate(codeId, codeValue, validate);
    }
}
