package com.pangding.web.system.dao.impl;

import com.pangding.web.system.dao.SystemWarnDao;
import com.pangding.web.vo.system.pd.SystemWarnVo;
import com.pangding.web.vo.system.req.SystemWarnPageReqVo;
import com.pangding.web.vo.system.res.SystemWarnResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class SystemWarnDaoImpl extends BaseDaoImpl implements SystemWarnDao {

    private final String QUERY_LIST = "QUERY_LIST";

    private final String QUERY_TOTAL = "QUERY_TOTAL";


    @Override
    protected void init() {
        register(SystemWarnVo.class);

        table.add(QUERY_LIST, " select a.*,b.enum_value as channelTypeName from pd_system_warning a " +
                " LEFT JOIN pd_enum b on a.channel_type = b.enum_key and b.child_type = 'channel_type'" +
                "  where 1=1 {WHERE}")
                .add("startDate"," and a.create_date >= ? ")
                .add("endDate"," and a.create_date <= ? ")
                .add("systemWarningId"," and system_warning_id = ? ")
                .add("warnType"," and warn_type = ? ")
                .add("warnName"," and warnName LIKE concat('%', ?,'%') ")
                .add("companyName"," and companyName LIKE concat('%', ?,'%')  ")
                .add("merchantName"," and merchantName LIKE concat('%', ?,'%')  ")
                .add("productName"," and productName LIKE concat('%', ?,'%')  ")
                .add("channelTypeList"," and channelTypeList in ( ? ) ")
                .add("warnStatusList"," and warnStatusList in ( ? ) ");

        table.add(QUERY_TOTAL, " select COUNT(1) as warnTotalNum, " +
                "SUM(case WHEN warn_status = 0 THEN 1 else 0 END) as unreadNum," +
                "SUM(case WHEN warn_status = 1 THEN 1 else 0 END) as readNum " +
                " from pd_system_warning a" +
                " where 1=1 {WHERE}")
                .add("startDate"," and create_date >= ? ")
                .add("endDate"," and create_date <= ? ")
                .add("systemWarningId"," and system_warning_id = ? ")
                .add("warnType"," and warn_type = ? ")
                .add("warnName"," and warnName LIKE concat('%', ?,'%') ")
                .add("companyName"," and companyName LIKE concat('%', ?,'%')  ")
                .add("merchantName"," and merchantName LIKE concat('%', ?,'%')  ")
                .add("productName"," and productName LIKE concat('%', ?,'%')  ")
                .add("channelTypeList"," and channelTypeList in ( ? ) ")
                .add("warnStatusList"," and warnStatusList in ( ? ) ");

    }

    public PageSizeData<SystemWarnResVo> findListPage(SystemWarnPageReqVo req){
        return this.queryPage(SystemWarnResVo.class, req, QUERY_LIST, req);

    }

    public SystemWarnResVo findListTotal(SystemWarnPageReqVo req){
        return this.queryFirst(SystemWarnResVo.class,  QUERY_TOTAL, req);

    }

}

