package com.pangding.web.authority.feign;

import com.pangding.web.vo.product.req.merchant.CompanyCompanySaveSimpleReqVo;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@FeignClient(value = "pd-interface-distribution")
@RestController
@RequestMapping(value = "/conversion", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface DistributionFeign {

    /**
     * 途比达推荐大屏数据
     * 公司信息保存
     */
    @PostMapping(value = "/sendCompanyInfo",produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseResult<String> sendCompanyInfo(CompanyCompanySaveSimpleReqVo req);

}
