package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.mq.CompanyConsumer;
import com.pangding.web.authority.service.FinanceService;
import com.pangding.web.authority.vo.reqvo.CompanyExtendGetReqVo;
import com.pangding.web.authority.vo.reqvo.WithdrawalReqVo;
import com.pangding.web.authority.vo.resvo.WithdrawalResVo;
import com.pangding.web.constant.CompanyConstant;
import com.pangding.web.vo.order.pd.CapitalFlowVo;
import com.pangding.web.vo.order.req.CapitalFlowReqVo;
import com.pangding.web.vo.order.req.back.CashWithdrawalBackReqVo;
import com.pangding.web.vo.order.res.CapitalFlowListResVo;
import com.pangding.web.vo.order.res.CapitalFlowResVo;
import com.pangding.web.vo.order.tl.CashWithdrawalReqVo;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.pd.company.CompanyMoneyVo;
import com.pangding.web.vo.system.req.company.UpdateCompanyMoneyReqVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/6/18 20:01
 */
@Service
public class FinanceServiceImpl implements FinanceService {

    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyExtendDao companyExtendDao;
    @Autowired
    private CapitalFlowDao capitalFlowDao;
    @Autowired
    private CompanyMoneyDao companyMoneyDao;

    @Autowired
    private CompanyConsumer companyConsumer;

    @Autowired
    private CompanyBankCardDao companyBankCardDaoImpl;

    @Override
    public WithdrawalResVo withdrawal(WithdrawalReqVo reqVo) {
        /*返回对象*/
        WithdrawalResVo resVo = new WithdrawalResVo();

        CompanyExtendGetReqVo getReqVo = new CompanyExtendGetReqVo();
        getReqVo.setId(reqVo.getCompanyId());
        CompanyExtendVo extendVo = companyExtendDao.load(getReqVo, CompanyExtendVo.class);
        if (null == extendVo) {
            throw new CodeException("未查到该公司数据");
        }
        resVo.setWithdrawTotalCash(extendVo.getWithdrawTotalCash());
        resVo.setCompanyExtend(extendVo);

        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDaoImpl.loadList(reqVo, CompanyBankCardVo.class);
        if (null == companyBankCardVoList || companyBankCardVoList.isEmpty()) {
            throw new CodeException("该公司暂无银行卡信息，请添加");
        }
        resVo.setBankCardVoList(companyBankCardVoList);
        return resVo;
    }

    /**
     * 查询订单列表
     *
     * @param req
     * @return
     */
    @Override
    public CapitalFlowListResVo findCapitalFlowList(CapitalFlowReqVo req) {
        CapitalFlowListResVo capitalFlowListResVo = new CapitalFlowListResVo();
        if (!StringHelper.isEmpty(req.getStartDate())) {
            req.setStartDate(req.getStartDate() + " 00:00:00");
        }
        if (!StringHelper.isEmpty(req.getEndDate())) {
            req.setEndDate(req.getEndDate() + " 23:59:59");
        }

        PageSizeData<CapitalFlowResVo> pageSizeData = capitalFlowDao.findCapitalFlowList(req);
        CapitalFlowResVo capitalFlowTotal = capitalFlowDao.findCapitalFlowTotal(req);

        capitalFlowListResVo.setCapitalFlowResVoPageSizeData(pageSizeData);
        capitalFlowListResVo.setCapitalFlowResVo(capitalFlowTotal);
        return capitalFlowListResVo;
    }


    /**
     * 申请提现
     *
     * @param req
     * @return
     */
    @Override
    public ResponseResult<CapitalFlowReqVo> applyWithdrawal(CapitalFlowReqVo req) {
        // 查找公司信息，提现信息
        CompanyResVo companyResVo = companyDao.load(req.getCompanyId(), CompanyResVo.class);
        CompanyBankCardVo companyBankCardVo = companyBankCardDaoImpl.load(req.getBankId(), CompanyBankCardVo.class);
        if (!StringHelper.isEmpty(companyResVo) && !StringHelper.isEmpty(companyBankCardVo)) {
            double withdrawFee = companyResVo.getWithdrawFee();
            double withdrawTotalCash = companyResVo.getWithdrawTotalCash();
            if (withdrawTotalCash < req.getOrderMoney()) {
                throw new CodeException("提现金额大于可提现余额");
            }
            CapitalFlowVo capitalFlowVo = new CapitalFlowVo();
            ObjectHelper.writeWithFrom(capitalFlowVo, req);
            capitalFlowVo.setOrderId(StringHelper.getNewID());
            capitalFlowVo.setCategory(1);
            capitalFlowVo.setOrderFee(withdrawFee);
            capitalFlowVo.setActualMoney(req.getOrderMoney() - capitalFlowVo.getOrderFee());
            capitalFlowVo.setTime(DateHelper.getNow());
            capitalFlowVo.setStatus(0);
            capitalFlowDao.save(capitalFlowVo);
            CashWithdrawalReqVo cashWithdrawalReqVo = new CashWithdrawalReqVo();
            ObjectHelper.writeWithFrom(cashWithdrawalReqVo, capitalFlowVo);
            cashWithdrawalReqVo.setActualType(companyResVo.getWithdrawType());
            cashWithdrawalReqVo.setBankCardType(companyBankCardVo.getType());
            companyConsumer.cashWithdrawal(cashWithdrawalReqVo);
            ResponseResult<CapitalFlowReqVo> responseResult = new ResponseResult<>();
            responseResult.setData(req);
            return responseResult;
        } else {
            throw new CodeException("未找到公司信息");
        }
    }

    /**
     * 提现回调
     *
     * @param req
     */
    @Transactional
    @Override
    public ResponseResult<String> withdrawalBack(CashWithdrawalBackReqVo req) {
        CapitalFlowVo capitalFlowVo = capitalFlowDao.load(req.getId(), CapitalFlowVo.class);
        if (!StringHelper.isEmpty(capitalFlowVo)) {
            capitalFlowVo.setStatus(req.getStatus());
            capitalFlowVo.setErrorMessage(req.getErrorMessage());
            capitalFlowVo.setTonglianId(req.getTonglianId());
            capitalFlowVo.setTime(DateHelper.getNow());
            if (1 == req.getStatus()) {
                // 修改公司金额
                UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
                updateCompanyMoneyReqVo.setCompanyId(req.getCompanyId());
                updateCompanyMoneyReqVo.setNewWithdrawTotalCash( -capitalFlowVo.getOrderMoney());
                companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);

                CompanyResVo companyResVo = companyDao.load(capitalFlowVo.getCompanyId(), CompanyResVo.class);
                if (!StringHelper.isEmpty(companyResVo)) {
                    double oldMoney = companyResVo.getWithdrawTotalCash() + capitalFlowVo.getOrderMoney();
                    double newMoney = oldMoney - capitalFlowVo.getOrderMoney();
                    capitalFlowVo.setInitMoney(oldMoney);
                    capitalFlowVo.setFinalMoney(newMoney);
                    saveCompanyMoney(capitalFlowVo, companyResVo, oldMoney);
                }
            }
            capitalFlowDao.update(capitalFlowVo);
        } else {
            throw new CodeException("订单信息错误。");
        }
        return ResponseResult.result("");
    }

    @Transactional
    @Override
    public ResponseResult<String> saveCapitalFlow(CapitalFlowReqVo req) {
        double money = req.getActualMoney();

        if (CompanyConstant.CATEGORY_REFUND == req.getCategory()) {
            // 退款
            money = -money;
        }
        //修改公司余额
        UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
        updateCompanyMoneyReqVo.setCompanyId(req.getCompanyId());
        updateCompanyMoneyReqVo.setNewWithdrawTotalCash(money);
        companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);

        CompanyResVo companyVo = companyDao.load(req.getCompanyId(), CompanyResVo.class);
        if (StringHelper.isEmpty(companyVo)) {
            throw new CodeException("未找到公司信息");
        }
        double oldMoney = companyVo.getWithdrawTotalCash() - money;
        // 添加资金流水
        CapitalFlowReqVo capitalFlowReqVo = new CapitalFlowReqVo();
        capitalFlowReqVo.setOrderId(req.getOrderId());
        CapitalFlowVo capitalFlowVo = capitalFlowDao.load(capitalFlowReqVo, CapitalFlowVo.class);
        if (StringHelper.isEmpty(capitalFlowVo)) {
            capitalFlowVo = new CapitalFlowVo();
            ObjectHelper.writeWithFrom(capitalFlowVo, req);
            capitalFlowVo.setStatus(1);
            capitalFlowVo.setTime(DateHelper.getNow());
            capitalFlowVo.setActualMoney(money);
            capitalFlowVo.setInitMoney(oldMoney);
            capitalFlowVo.setFinalMoney(capitalFlowVo.getActualMoney() + capitalFlowVo.getInitMoney());
            capitalFlowDao.save(capitalFlowVo);
        } else {
            ObjectHelper.writeWithFrom(capitalFlowVo, req);
            capitalFlowVo.setStatus(1);
            capitalFlowVo.setTime(DateHelper.getNow());
            capitalFlowVo.setActualMoney(money);
            capitalFlowVo.setInitMoney(oldMoney);
            capitalFlowVo.setFinalMoney(capitalFlowVo.getActualMoney() + capitalFlowVo.getInitMoney());
            capitalFlowDao.update(capitalFlowVo);
        }
        saveCompanyMoney(capitalFlowVo, companyVo, oldMoney);
        return ResponseResult.result("处理完成");
    }

    @Override
    public void updateCompanyMoney(UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo){
        companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);
    }


    public void saveCompanyMoney(CapitalFlowVo capitalFlowVo, CompanyResVo companyVo, double initMoney){
        //修改公司余额
        double oldMoney = initMoney ;
        double inMoney = 0d, outMoney = 0d, refundMoney = 0d;
        int inNumber = 0, outNumber = 0, refundNumber = 0;
        if (CompanyConstant.CATEGORY_ENTRY == capitalFlowVo.getCategory()
                || CompanyConstant.CATEGORY_RECHARGE == capitalFlowVo.getCategory()
                || CompanyConstant.CATEGORY_DIVIDEND == capitalFlowVo.getCategory()) {
            // 交易订单金额 充值 分润
            inNumber = 1;
            inMoney = capitalFlowVo.getActualMoney();
        }
        if (CompanyConstant.CATEGORY_REFUND == capitalFlowVo.getCategory()) {
            // 退款
            refundNumber = 1;
            refundMoney = capitalFlowVo.getActualMoney();
        }
        if (CompanyConstant.CATEGORY_WITHDRAWAL == capitalFlowVo.getCategory()) {
            // 提现
            outNumber = 1;
            outMoney = -capitalFlowVo.getOrderMoney();
        }
        CompanyMoneyVo companyMoneyReqVo = new CompanyMoneyVo();
        companyMoneyReqVo.setDailyDate(DateHelper.getToday());
        companyMoneyReqVo.setCompanyId(companyVo.getId());
        CompanyMoneyVo companyMoneyVo = companyMoneyDao.load(companyMoneyReqVo, CompanyMoneyVo.class);
        if (StringHelper.isEmpty(companyMoneyVo)) {
            companyMoneyVo = new CompanyMoneyVo();
            companyMoneyVo.setCompanyMoneyId(StringHelper.getNewID());
            companyMoneyVo.setCompanyId(companyVo.getId());
            companyMoneyVo.setDailyDate(DateHelper.getToday());
            companyMoneyVo.setCompanyName(companyVo.getCompanyName());
            companyMoneyVo.setInitMoney(oldMoney);
            companyMoneyVo.setInMoney(inMoney);
            companyMoneyVo.setOutMoney(outMoney);
            companyMoneyVo.setRefundMoney(refundMoney);
            companyMoneyVo.setFinalMoney(companyMoneyVo.getInitMoney() + companyMoneyVo.getInMoney() + companyMoneyVo.getOutMoney()
                    + companyMoneyVo.getRefundMoney());
            companyMoneyVo.setInNumber(inNumber);
            companyMoneyVo.setOutNumber(outNumber);
            companyMoneyVo.setRefundNumber(refundNumber);
            companyMoneyDao.create(companyMoneyVo);
        } else {
            companyMoneyVo.setInMoney(inMoney );
            companyMoneyVo.setOutMoney(outMoney );
            companyMoneyVo.setRefundMoney(refundMoney);
            companyMoneyVo.setInNumber(inNumber );
            companyMoneyVo.setOutNumber(outNumber );
            companyMoneyVo.setRefundNumber(refundNumber);
            companyMoneyDao.updateCompanyMoney(companyMoneyVo);
        }
    }




}
