package com.pangding.web.authority.dao.company.impl;

import com.pangding.web.authority.dao.company.CompanyExtendDao;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.req.company.UpdateCompanyMoneyReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/16 17:22
 */
@Component
public class CompanyExtendDaoImpl extends BaseDaoImpl implements CompanyExtendDao {


    private static final String UPDATE_COMPANY_MONEY = "UPDATE_COMPANY_MONEY";

    private static final String UPDATE_COMPANY_INVITED_PEOPLE = "UPDATE_COMPANY_INVITED_PEOPLE";


    @Override
    protected void init() {
        register(CompanyExtendVo.class);

        table.add(UPDATE_COMPANY_MONEY, "UPDATE pd_company_extend SET withdraw_total_cash = withdraw_total_cash + @newWithdrawTotalCash{FIELD} " +
                "WHERE id = @companyId ")
                .addPara("frozenMoney", "{FIELD}",",frozen_money = frozen_money + @frozenMoney")
                .addPara("lateFee", "{FIELD}", ",late_fee = late_fee + @lateFee");

        table.add(UPDATE_COMPANY_INVITED_PEOPLE, "UPDATE pd_company_extend SET " +
                "invited_people = invited_people + @invitedPeople " +
                "WHERE id = @companyId ");

    }

    @Override
    public void updateCompanyMoney(UpdateCompanyMoneyReqVo req) {
        this.updateSql(UPDATE_COMPANY_MONEY, req);
    }


    @Override
    public void updateCompanyInvitedPeople(UpdateCompanyMoneyReqVo req) {
        this.updateSql(UPDATE_COMPANY_INVITED_PEOPLE, req);
    }
}
