package com.pangding.web.authority.service.company.impl;

import com.pangding.web.authority.dao.company.*;
import com.pangding.web.authority.dao.CompanyRuleDao;
import com.pangding.web.authority.feign.PayFeign;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.service.company.CompanyRuleService;
import com.pangding.web.authority.service.company.NewCompanyService;
import com.pangding.web.constant.CompanyConstant;
import com.pangding.web.vo.product.req.merchant.MerchantRegVo;
import com.pangding.web.vo.system.pd.company.*;
import com.pangding.web.vo.system.req.authority.UserReqVo;
import com.pangding.web.vo.system.req.company.*;
import com.pangding.web.vo.system.res.company.CompanyNumberResVo;
import com.pangding.web.vo.system.res.company.CompanyPageResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class NewCompanyServiceImpl implements NewCompanyService {

    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyExtendDao companyExtendDao;
    @Autowired
    private CompanyBankCardDao companyBankCardDao;
    @Autowired
    private CompanyRuleDao companyRuleDao;
    @Autowired
    private CompanyExamineDao companyExamineDao;
    @Autowired
    private CompanyMerchantDao companyMerchantDao;
    @Autowired
    private UserService userService;
    @Autowired
    private CompanyRuleService companyRuleService;
    @Autowired
    private PayFeign payFeign;

    @Override
    public CompanyPageResVo findCompanyListPage(CompanyReqVo req) {
        CompanyPageResVo companyPageResVo = new CompanyPageResVo();
        // 公司分页列表
        PageSizeData<CompanyResVo> pageSizeData = companyDao.findCompanyListPage(req);
        companyPageResVo.setCompanyResVoPageSizeData(pageSizeData);
        // 公司数量
        CompanyNumberResVo companyNumberResVo = companyDao.findCompanyTotal(req);
        companyPageResVo.setCompanyNumberResVo(companyNumberResVo);
        return companyPageResVo;
    }

    @Override
    public List<CompanyResVo> findCompanyList(CompanyReqVo req) {
        List<CompanyResVo> companyResVoList = companyDao.findCompanyList(req);
        return companyResVoList;
    }

    @Override
    public CompanyResVo findCompany(CompanyReqVo req) {
        // 获取公司信息
        CompanyResVo companyResVo = companyDao.load(req.getId(), CompanyResVo.class);
        if (StringHelper.isEmpty(companyResVo)) {
            throw new CodeException("暂无公司信息");
        }
        // 查询公司信息审核信息
        CompanyExamineVo companyExamineReqVo = new CompanyExamineVo();
        companyExamineReqVo.setCompanyId(companyResVo.getId());
        List<CompanyExamineVo> companyExamineVoList = companyExamineDao.loadList(companyExamineReqVo, CompanyExamineVo.class);
        companyResVo.setCompanyExamineVoList(companyExamineVoList);

        // 查询公司银行卡信息
        CompanyBankCardReqVo companyBankCardReqVo = new CompanyBankCardReqVo();
        companyBankCardReqVo.setCompanyId(companyResVo.getId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDao.loadList(companyBankCardReqVo, CompanyBankCardVo.class);
        companyResVo.setCompanyBankCardVoList(companyBankCardVoList);

        // 获取公司规则信息 提现规则
        CompanyRuleReqVo companyRuleReqVo = new CompanyRuleReqVo();
        companyRuleReqVo.setCompanyId(companyResVo.getId());
        List<CompanyRuleVo> companyRuleVoList = companyRuleDao.loadList(companyRuleReqVo, CompanyRuleVo.class);
        companyResVo.setCompanyRuleVoList(companyRuleVoList);

        // 获取公司行业信息
        CompanyMerchantVo companyMerchantReqVo = new CompanyMerchantVo();
        companyMerchantReqVo.setCompanyId(companyResVo.getId());
        List<CompanyMerchantVo> companyMerchantVoList = companyMerchantDao.loadList(companyMerchantReqVo, CompanyMerchantVo.class);
        companyResVo.setCompanyMerchantVoList(companyMerchantVoList);

        // 查询公司管理员信息
        UserReqVo userReqVo = new UserReqVo();
        userReqVo.setIsFirst(1);
        userReqVo.setCompanyId(req.getId());
        companyResVo.setUserVo(userService.queryUser(userReqVo));

        // 查询公司角色信息
//        RoleReqVo roleReqVo = new RoleReqVo();
//        roleReqVo.setCompanyId(req.getId());
//        RoleVo roleVo = roleDao.load(roleReqVo, RoleVo.class);

        return companyResVo;
    }


    @Override
    public ResponseResult<SaveCompanyReqVo> updateCompanyInfo(SaveCompanyReqVo req) {
        // 返回参数
        ResponseResult<SaveCompanyReqVo> responseResult = new ResponseResult<>();
        // 查询公司信息
        CompanyResVo companyResVo = companyDao.load(req.getCompanyVo().getId(), CompanyResVo.class);
        if (StringHelper.isEmpty(companyResVo)) {
            // 公司信息为空
            return ResponseResult.error("99", "注册信息有误");
        }
//        ObjectHelper.writeWithFrom(companyResVo, req.getCompanyVo());
//        companyResVo.setAddress(req.getCompanyVo().getAddress());
        companyResVo.setUpdateTime(DateHelper.getNow());
        if (CompanyConstant.COMPANY_STATUS_BIND_PHONE < companyResVo.getStatus()) {
            // 公司状态小于电话已绑定，已经通过通联实名认证，不可修改公司的基本信息
        } else {
            CompanyVo companyVo = new CompanyVo();
            ObjectHelper.writeWithFrom(companyResVo, req.getCompanyVo());
            ObjectHelper.writeWithFrom(companyVo, companyResVo);

//            if (StringHelper.isEmpty(req.getCompanyVo().getCompanyName())) {
//                companyResVo.setCompanyName(req.getMerchantVo().getName());
//                if (PangdConstant.ATTRIBUTE_TAXI == companyVo.getCompanyAttribute()) {
//                    companyResVo.setCompanyName(req.getMerchantVo().getName() + companyVo.getContactName());
//                }
//            }
        }
        // 调用通联实名制
        SaveCompanyReqVo companyReqVo = new SaveCompanyReqVo();
        companyReqVo.setCompanyVo(companyResVo);
        companyReqVo.setVerifyCode(req.getVerifyCode());
        switch (companyResVo.getCompanyType()) {
            case CompanyConstant.COMPANY_TYPE_COMPANY:
                // 公司  1判断银行卡id是否存在，存在则查询银行卡
                CompanyBankCardVo companyBankCardVo = saveCompanyBank(companyResVo, req);
                companyReqVo.setCompanyBankCardVo(companyBankCardVo);
                break;
        }
        responseResult = payFeign.setCompanyInfo1(companyReqVo);
        SaveCompanyReqVo saveCompanyReqVo = responseResult.getData();
        ObjectHelper.writeWithFrom(companyResVo, saveCompanyReqVo.getCompanyVo());


        CompanyBankCardVo companyBankCardVo = responseResult.getData().getCompanyBankCardVo();
        if (!StringHelper.isEmpty(companyBankCardVo)) {
            if (StringHelper.isEmpty(responseResult.getData().getErrorMessage())) {
                companyBankCardVo.setStatus(1);
                companyBankCardVo.setBindingTime(DateHelper.getNow());
                companyBankCardVo.setBindingCode("");
            }
            companyBankCardDao.update(companyBankCardVo);
        }

        // 保存行业商户信息 todo
        Integer companyAttribute = saveCompanyMerchant(req.getMerchantRegVoList(), companyResVo.getId());
        companyResVo.setCompanyAttribute(companyAttribute);
        companyDao.update(companyResVo);

        if (StringHelper.isEmpty(saveCompanyReqVo.getErrorMessage())) {
            // 错误信息为空，发送验证码成功 修改信息成功
            return responseResult;
        } else {
            return ResponseResult.error("99", saveCompanyReqVo.getErrorMessage());
        }
    }

    /**
     * 实名认证时保存银行卡信息
     *
     * @param companyResVo
     * @param req
     * @return
     */
    private CompanyBankCardVo saveCompanyBank(CompanyResVo companyResVo, SaveCompanyReqVo req) {
        Date date = DateHelper.getDateTime(companyResVo.getCreateTime());
        String bankId = StringHelper.getNewIdMD5(date, req.getCompanyVo().getId(), req.getCompanyBankCardVo().getBankCardCode());
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(bankId, CompanyBankCardVo.class);
        if (StringHelper.isEmpty(companyBankCardVo)) {
            companyBankCardVo = new CompanyBankCardVo();
            ObjectHelper.writeWithFrom(companyBankCardVo, req.getCompanyBankCardVo());
            companyBankCardVo.setId(bankId);
            companyBankCardVo.setName(req.getCompanyVo().getContactName());
            companyBankCardVo.setIdCard(req.getCompanyVo().getContactCode());
            companyBankCardVo.setCompanyId(req.getCompanyVo().getId());
            companyBankCardVo.setType(1);
            companyBankCardVo.setStatus(0);
            companyBankCardVo.setIsDefault(0);
            companyBankCardDao.create(companyBankCardVo);
        } else {
            ObjectHelper.writeWithFrom(companyBankCardVo, req.getCompanyBankCardVo());
            companyBankCardVo.setId(bankId);
            companyBankCardDao.update(companyBankCardVo);
        }
        return companyBankCardVo;
    }

    public Integer saveCompanyMerchant(List<MerchantRegVo> merchantRegVoList, String companyId) {
        Integer companyAttribute = 0;
        // 删除当前公司的所有行业属性
        CompanyMerchantVo delCompanyMerchantVo = new CompanyMerchantVo();
        delCompanyMerchantVo.setCompanyId(companyId);
        companyMerchantDao.remove(delCompanyMerchantVo);

        // 新增当前公司的行业属性
        List<CompanyMerchantVo> companyMerchantVoList = new ArrayList<>();
        for (MerchantRegVo merchantRegVo : merchantRegVoList) {
            CompanyMerchantVo companyMerchantVo = new CompanyMerchantVo();
            if (StringHelper.isEmpty(merchantRegVo.getMerchantId())) {
                companyMerchantVo.setMerchantId(StringHelper.getNewID());
            }
            companyMerchantVo.setCompanyMerchantId(StringHelper.getNewID());
            companyMerchantVo.setCompanyId(companyId);
            companyMerchantVo.setMerchantType(merchantRegVo.getMerchantType());
            companyMerchantVo.setTitleName(merchantRegVo.getTitleName());
            merchantRegVo.setMerchantId(companyMerchantVo.getMerchantId());
            companyMerchantVoList.add(companyMerchantVo);
//            companyAttribute = merchantRegVo.getMerchantTypeName();
        }
        companyMerchantDao.saveArray(companyMerchantVoList);

        // todo 调用运营保存商户信息
//        if (PangdConstant.ATTRIBUTE_TAXI != companyResVo.getCompanyAttribute()) {
//            /*保存或更新商户表*/
//            MerchantCreateReqVo merchantCreateReqVo = new MerchantCreateReqVo();
//            ObjectHelper.writeWithFrom(merchantCreateReqVo, req.getMerchantVo());
//            merchantCreateReqVo.setAddress(req.getCompanyVo().getAddress());
//            merchantCreateReqVo.setType(req.getCompanyVo().getCompanyAttribute());
//            merchantCreateReqVo.setProductCompanyId(companyResVo.getId());
//            merchantCreateReqVo.setProductCompanyName(req.getCompanyVo().getCompanyName());
//            merchantCreateReqVo.setUserId(req.getUserVo().getId());
//            merchantCreateReqVo.setUsername(req.getUserVo().getAccount());
//            merchantCreateReqVo.setReqId(StringHelper.getNewID());
//            merchantCreateReqVo.setCreateTime(DateHelper.getNow());
//
//            if (!StringHelper.isEmpty(merchantCreateReqVo.getId())) {
//                merchantCreateReqVo.setId(StringHelper.getNewID());
//            }
//            ResponseResult<MerchantVo> merchantResponseResult = storeFeign.merchantCreate(merchantCreateReqVo);
//            if (merchantResponseResult.getCode().equals("00")) {
//                MerchantVo merchantVo = merchantResponseResult.getData();
//                saveCompanyReqVo.setMerchantVo(merchantVo);
//            }
//        }
        return companyAttribute;
    }


    /**
     * 检查邀请码是否正确
     *
     * @param invitationCode
     */
    public CompanyResVo checkInvitationCode(String invitationCode) {
        // 验证邀请码是否正确 todo 关联码怎么判断
        CompanyReqVo req = new CompanyReqVo();
        req.setInvitationCode(invitationCode);
        CompanyResVo companyResVo = companyDao.findCompany(req);
        if (StringHelper.isEmpty(companyResVo)) {
            // 邀请码不正确
            throw new CodeException("注册编码错误.");
        }
        // 如果子级邀请码不为空 并且等于用户填写的邀请码 设置邀请码类型
        if (!StringHelper.isEmpty(companyResVo.getChildInvitationCode()) && companyResVo.getChildInvitationCode().equals(invitationCode)) {
            companyResVo.setInvitationCodeType(CompanyConstant.RELATION_CODE);
        }
        if (!StringHelper.isEmpty(companyResVo.getInvitationCode()) && companyResVo.getInvitationCode().equals(invitationCode)) {
            companyResVo.setInvitationCodeType(CompanyConstant.INVITATION_CODE);

            // 判断邀请公司状态
            if (0 == companyResVo.getInvitationStatus() || 1 != companyResVo.getExamineStatus()) {
                throw new CodeException("用户邀请状态错误：" + companyResVo.getInvitationStatus() + ",状态错误：" + companyResVo.getExamineStatus());
            }
            // 判断该账户已经邀请的人数
            if (companyResVo.getInviteesPeople() <= companyResVo.getInvitedPeople()) {
                throw new CodeException("邀请人数已超过可邀请人数，注册失败。可邀请人数为：" + companyResVo.getInviteesPeople());
            }
            // 添加用户邀请人数
            UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
            updateCompanyMoneyReqVo.setCompanyId(companyResVo.getId());
            updateCompanyMoneyReqVo.setInvitedPeople(1);
            companyExtendDao.updateCompanyInvitedPeople(updateCompanyMoneyReqVo);
        }

        return companyResVo;
    }

    public void examineCompany(ExamineCompanyReqVo req) {
        // 找到公司信息
        CompanyResVo companyResVo = companyDao.load(req.getCompanyId(), CompanyResVo.class);
        if (StringHelper.isEmpty(companyResVo)) {
            throw new CodeException("公司信息错误");
        }
        CompanyExtendVo companyExtendVo = new CompanyExtendVo();
        ObjectHelper.writeWithFromClass(companyExtendVo, companyResVo);
        ObjectHelper.writeWithFromClass(companyExtendVo, req);
        companyExtendDao.update(companyExtendVo);

        // 保存公司行业信息
        saveCompanyMerchant(req.getMerchantRegVoList(), companyResVo.getId());

        // 更新或新增提现规则表
        companyRuleService.saveCompanyRule(req.getCompanyRuleVoList(), companyResVo.getId());

        //保存审核信息
        saveCompanyExamin(null, companyResVo.getId());

        // 公司激活状态 审核通过状态 公司邀请奖励
//        if (1 == reqVo.getActivationStatus() && 1 == reqVo.getExamineStatus()) {
//            CompanyResVo companyResVo = new CompanyResVo();
//            ObjectHelper.writeWithFromClass(companyResVo, companyVo);
//            ObjectHelper.writeWithFromClass(companyResVo, companyExtendVo);
//            companyResVo.setRewardType(CompanyConstant.CATEGORY_ACTIVATION_BONUS);
//            companyConsumer.companyReward(companyResVo);
//        }
        // 公司审核通过 同步给大数据平台
//        if (1 == reqVo.getExamineStatus()) {
//            CompanyResVo companyResVo = new CompanyResVo();
//            ObjectHelper.writeWithFromClass(companyResVo, companyVo);
//            ObjectHelper.writeWithFromClass(companyResVo, companyExtendVo);
//            companyConsumer.synCompany(companyResVo);
//        }

    }

    public void saveCompanyExamin(List<CompanyExamineVo> companyExamineVoList, String companyId) {

        // 删除当前公司的审核信息
        CompanyExamineVo delCompanyExaminVo = new CompanyExamineVo();
        delCompanyExaminVo.setCompanyId(companyId);
        companyExamineDao.remove(delCompanyExaminVo);

        // 新增当前公司的审核信息
        List<CompanyExamineVo> saveCompanyExamineVoList = new ArrayList<>();
        for (int i = 0; i < companyExamineVoList.size(); i++) {
            CompanyExamineVo companyExamineVo = companyExamineVoList.get(i);
            CompanyExamineVo sqlCompanyExamineVo = new CompanyExamineVo();
            ObjectHelper.writeWithFromClass(sqlCompanyExamineVo, companyExamineVo);
            sqlCompanyExamineVo.setCompanyId(companyId);
            sqlCompanyExamineVo.setCompanyExamineId(StringHelper.getNewID());
            saveCompanyExamineVoList.add(sqlCompanyExamineVo);
        }
        companyExamineDao.saveArray(saveCompanyExamineVoList);
    }
}
