package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.dao.company.CompanyBankCardDao;
import com.pangding.web.authority.dao.company.CompanyDao;
import com.pangding.web.authority.dao.company.CompanyExtendDao;
import com.pangding.web.authority.dao.company.CompanyMerchantDao;
import com.pangding.web.authority.feign.StoreFeign;
import com.pangding.web.authority.service.TokenService;
import com.pangding.web.authority.service.company.NewCompanyService;
import com.pangding.web.authority.util.RsaConstant;
import com.pangding.web.authority.util.TokenUtil;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.resvo.WebUserResVo;
import com.pangding.web.constant.AuthorityConstant;
import com.pangding.web.constant.CompanyConstant;
import com.pangding.web.constant.PangdConstant;
import com.pangding.web.util.RSAUtils;
import com.pangding.web.vo.product.pd.merchant.MerchantVo;
import com.pangding.web.vo.system.pd.LoginTokenVo;
import com.pangding.web.vo.system.pd.authority.*;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.pd.company.CompanyMerchantVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.LoginReqVo;
import com.pangding.web.vo.system.req.authority.AuthorityReqVo;
import com.pangding.web.vo.system.req.authority.SaveUserReqVo;
import com.pangding.web.vo.system.req.authority.UserReqVo;
import com.pangding.web.vo.system.res.LoginResVo;
import com.pangding.web.vo.system.res.authority.AuthorityListByLevelResVo;
import com.pangding.web.vo.system.res.authority.AuthorityResVo;
import com.pangding.web.vo.system.res.authority.UserResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.pangding.web.vo.system.res.company.LoginCompanyResVo;
import com.yanzuoguang.token.TokenHelper;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjinyao
 */
@Service
public class UserServiceImpl implements UserService {

    @Autowired
    UserDao userDao;
    @Autowired
    UserRoleDao userRoleDao;
    @Autowired
    RoleDao roleDao;
    @Autowired
    private RoleAuthorityDao roleAuthorityDao;
    @Autowired
    private AuthorityDao authorityDao;
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyExtendDao companyExtendDao;
    @Autowired
    private CompanyBankCardDao companyBankCardDao;
    @Autowired
    private CompanyMerchantDao companyMerchantdao;
    @Autowired
    private NewCompanyService newCompanyService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private StoreFeign storeFeign;


    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    @Override
    public LoginResVo login(LoginReqVo reqVo) {

        // 查询用户是否存在
        UserReqVo userReqVo = new UserReqVo();
        userReqVo.setLoginAccount(reqVo.getAccountOrPhone());
        UserVo userVo = userDao.queryUser(userReqVo);
        if (StringHelper.isEmpty(userVo)) {
            throw new CodeException("用户名不存在");
        }
        //通过私钥将rsa加密的密码解密 并检查密码是否相等
        try {
            String password = RSAUtils.decryptionByPrivateKey(reqVo.getPassword(), RsaConstant.privateKey);
            if (!(StringHelper.md5(password).equals(userVo.getPassword()))) {
                throw new CodeException("用户名或密码错误");
            }
        } catch (Exception e) {
            throw new CodeException(e.getMessage());
        }

        if (StringHelper.isEmpty(userVo.getCompanyId())) {
            throw new CodeException("用户信息有误，请联系管理员");
        }

        String token = TokenUtil.createToken(reqVo.getAccountOrPhone());

        // 登录返回参数
        LoginResVo resVo = new LoginResVo();
        resVo.setToken(token);
        userVo.setPassword("");
        userVo.setRemark("");
        resVo.setUserVo(userVo);

        // 保存登录token
        LoginTokenVo loginVo = new LoginTokenVo();
        loginVo.setToken(token);
        loginVo.setDataPwd(token);
        loginVo.setData(JsonHelper.serialize(reqVo));
        loginVo.setExpairTime(DateHelper.getNow());
        tokenService.save(loginVo);
        // 输出结果
        TokenHelper.write(token, loginVo);

        // 找到登录用户公司信息
        CompanyResVo companyVo = companyDao.load(userVo.getCompanyId(), CompanyResVo.class);
        if (StringHelper.isEmpty(companyVo)) {
            throw new CodeException("注册信息有误");
        }
        LoginCompanyResVo loginCompanyResVo = new LoginCompanyResVo();
        loginCompanyResVo.setCompanyVo(companyVo);
        reqVo.setToken(token);

        // 找到公司银行信息
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(companyVo.getId());
        getReqVo.setIsDefault(1);
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(getReqVo, CompanyBankCardVo.class);
        loginCompanyResVo.setCompanyBankCardVo(companyBankCardVo);
        resVo.setCompanyResVo(loginCompanyResVo);

        // 找到公司的行业属性
        CompanyMerchantVo companyMerchantReqVo = new CompanyMerchantVo();
        companyMerchantReqVo.setCompanyId(companyVo.getId());
        List<CompanyMerchantVo> companyMerchantVoList = companyMerchantdao.loadList(companyMerchantReqVo, CompanyMerchantVo.class);
        loginCompanyResVo.setCompanyMerchantVoList(companyMerchantVoList);

        //获取商家信息 todo  登录的时候是否需要商户信息
        CompanyScenicInfoReqVo companyScenicInfoReqVo = new CompanyScenicInfoReqVo();
        companyScenicInfoReqVo.setReqId(StringHelper.getNewID());
        companyScenicInfoReqVo.setCompanyId(companyVo.getId());
        companyScenicInfoReqVo.setProductOrInterface(0);
        try {
            ResponseResult result = storeFeign.getCompanyScenicInfo(companyScenicInfoReqVo);
            MerchantVo merchant = (MerchantVo) result.getData();
            resVo.setMerchant(merchant);
        } catch (Exception e) {
            resVo.setMerchant(null);
        }

        // 判断基本信息是否完善，及状态是否为2，且为个人用户，若不完善则跳转个人完善页面
        if (companyVo.getStatus() < (CompanyConstant.COMPANY_STATUS_BIND_PHONE) && CompanyConstant.COMPANY_TYPE_PERSON == (companyVo.getCompanyType())) {
            resVo.setCode("01");
            resVo.setMsg("个人基本信息未完善，跳转个人完善页面");
            return resVo;
        }
        // 判断基本信息是否完善，及状态是否为2，且为公司用户，若不完善则跳转个人完善页面
        else if (companyVo.getStatus() < (CompanyConstant.COMPANY_STATUS_BIND_PHONE) && (CompanyConstant.COMPANY_TYPE_COMPANY == (companyVo.getCompanyType()))) {
            resVo.setCode("02");
            resVo.setMsg("公司基本信息未完善，跳转公司完善页面");
            return resVo;
        }

        /*获取用户权限列表*/
        RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
        roleAuthorityGetReqVo.setUserId(userVo.getId());
        List<AuthorityListByLevelResVo> roleAuthorityVoList = roleAuthorityDao.loadList(roleAuthorityGetReqVo, AuthorityListByLevelResVo.class);
        resVo.setAuthorityListByLevel(AuthorityServiceImpl.getChildList(roleAuthorityVoList, false));

        resVo.setCompanyResVo(loginCompanyResVo);

        resVo.setCode("00");
        return resVo;
    }

    @Override
    @Transactional(rollbackFor = RuntimeException.class)
    public ResponseResult<String> registerSaveUser(SaveUserReqVo saveUserReqVo) {
        // 用户名是否存在
        UserReqVo userReqVo = new UserReqVo();
        userReqVo.setAccount(saveUserReqVo.getAccount());
        UserVo userVo = userDao.load(userReqVo, UserVo.class);
        if (!StringHelper.isEmpty(userVo)) {
            // 用户名已存在
            return ResponseResult.error("99", "该用户名已存在");
        }
        try {
            /*将RSA加密后的密码解密*/
            String password = saveUserReqVo.getPassword(); //RSAUtils.decryptionByPrivateKey(saveUserReqVo.getPassword(), RsaConstant.privateKey);
            String confirmPassword = saveUserReqVo.getConfirmPassword(); //RSAUtils.decryptionByPrivateKey(saveUserReqVo.getConfirmPassword(), RsaConstant.privateKey);
            if (!StringHelper.compare(password, confirmPassword)) {
                return ResponseResult.error("99", "两次填写的密码不相等");
            }

            // 验证邀请码是否正确 todo 关联码怎么判断
            CompanyResVo companyResVo = newCompanyService.checkInvitationCode(saveUserReqVo.getInvitationCode());

            String companyId = StringHelper.getNewID();
            String userId = StringHelper.getNewID();

            // 保存用户表
            userVo = new UserVo();
            userVo.setId(userId);
            userVo.setAccount(saveUserReqVo.getAccount());
            userVo.setPassword(this.passwordEncoder(password));
            userVo.setRemark(password);
            userVo.setCompanyId(companyId);
            userVo.setName(saveUserReqVo.getName());
            userVo.setPhone(saveUserReqVo.getPhone());
            userVo.setCreateTime(DateHelper.getNow());
            userVo.setCreateId(userId);
            userVo.setCreateName(saveUserReqVo.getAccount());
            userVo.setStatus(0);
            userDao.create(userVo);

            // 保存公司表
            CompanyVo companyVo = new CompanyVo();
            companyVo.setId(companyId);
            companyVo.setInvitationCompanyId(companyResVo.getId());
            companyVo.setInvitationCompanyName(companyResVo.getCompanyName());
            companyVo.setInvitationCodeType(companyResVo.getInvitationCodeType());
            if(CompanyConstant.RELATION_CODE == companyResVo.getInvitationCodeType()){
                // 邀请码为关联码  需关联父级
                companyVo.setPid(companyResVo.getId());
                companyVo.setPcompanyName(companyResVo.getCompanyName());
            }
            companyVo.setStatus(CompanyConstant.COMPANY_STATUS_INIT);
            companyVo.setNature(saveUserReqVo.getCompanyType());
            if (3 == companyVo.getNature()) {
                companyVo.setCompanyType(0);
            } else {
                companyVo.setCompanyType(1);
            }
            companyVo.setSigningStatus(0);
            companyVo.setCreateTime(DateHelper.getNow());
            companyVo.setProductOrInterface(0);
            companyVo.setExamineStatus(0);
            companyDao.create(companyVo);
            // 保存公司扩展信息表
            CompanyExtendVo companyExtendVo = new CompanyExtendVo();
            companyExtendVo.setId(companyId);
            companyExtendDao.create(companyExtendVo);

            String roleId = StringHelper.getNewID();
            // 保存角色表
            RoleVo roleVo = new RoleVo();
            roleVo.setId(roleId);
            roleVo.setCompanyId(companyId);
            roleVo.setName(saveUserReqVo.getAccount() + "Admin");
            roleVo.setRemark(saveUserReqVo.getAccount() + "Admin");
            roleDao.create(roleVo);
            // 保存角色用户表
            UserRoleVo userRoleVo = new UserRoleVo();
            userRoleVo.setId(StringHelper.getNewID());
            userRoleVo.setUserId(userId);
            userRoleVo.setRoleId(roleId);
            userRoleDao.create(userRoleVo);
            // 保存角色权限表 先查询默认权限，跟角色添加默认权限
            AuthorityReqVo authorityReqVo = new AuthorityReqVo();
            authorityReqVo.setAttribute(PangdConstant.ATTRIBUTE_SCENIC);
            authorityReqVo.setAuthorityLevel(AuthorityConstant.AUTHORITY_LEVEL_DEFAULT);
            List<AuthorityResVo> authorityResVoList = authorityDao.loadList(authorityReqVo, AuthorityResVo.class);
            for (int i = 0; i < authorityResVoList.size(); i++) {
                AuthorityResVo authorityResVo = authorityResVoList.get(i);
                RoleAuthorityVo roleAuthorityVo = new RoleAuthorityVo();
                roleAuthorityVo.setId(StringHelper.getNewID());
                roleAuthorityVo.setAuthorityId(authorityResVo.getId());
                roleAuthorityVo.setRoleId(roleId);
                roleAuthorityDao.create(roleAuthorityVo);
            }
            return ResponseResult.result("注册成功");
        } catch (Exception e) {
            return ResponseResult.error("99", e.getMessage());
        }
    }


    @Override
    public UserResVo queryUser(UserReqVo req) {
        return userDao.queryUser(req);
    }

    /**************************************/

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveUser(WebUserReqVo webUserReqVo) throws Exception {
        this.isValid(webUserReqVo.getAccount());
        this.checkAccount(webUserReqVo);
        this.checkPhone(webUserReqVo);
        this.checkEmail(webUserReqVo.getEmail());

        /*将RSA加密后的密码解密*/
        String password = RSAUtils.decryptionByPrivateKey(webUserReqVo.getPassword(), RsaConstant.privateKey);
        String confirmPassword = RSAUtils.decryptionByPrivateKey(webUserReqVo.getConfirmPassword(), RsaConstant.privateKey);
        if (!StringHelper.compare(password, confirmPassword)) {
            throw new CodeException("确认密码错误");
        }

        webUserReqVo.setRemark(password);
        String md5Password = this.passwordEncoder(password);
        webUserReqVo.setPassword(md5Password);

        UserVo userVo = new UserVo();
        if (null == webUserReqVo.getId() || webUserReqVo.getId().isEmpty()) {
            webUserReqVo.setId(StringHelper.getNewID());
            ObjectHelper.writeWithFrom(userVo, webUserReqVo);
            UserGetReqVo userGetReqVo = new UserGetReqVo();
            userGetReqVo.setCompanyId(webUserReqVo.getCompanyId());
            userGetReqVo.setIsFirst(1);
            UserVo userVo1 = userDao.load(userGetReqVo, UserVo.class);
            if (null != userVo1) {
                userVo.setIsFirst(0);
            } else {
                userVo.setIsFirst(1);
            }
            userDao.create(userVo);
        } else {
            ObjectHelper.writeWithFrom(userVo, webUserReqVo);
            UserGetReqVo userGetReqVo = new UserGetReqVo();
            userGetReqVo.setId(webUserReqVo.getId());
            UserVo userVo1 = userDao.load(userGetReqVo, UserVo.class);
            userVo.setIsFirst(userVo1.getIsFirst());
            userDao.update(userVo);
        }

        saveUserRole(webUserReqVo);

        return userVo.getId();
    }

    private void saveUserRole(WebUserReqVo webUserReqVo) {
        if (webUserReqVo.getRoleIds() != null && !webUserReqVo.getRoleIds().isEmpty()) {
            List<String> roleIds = webUserReqVo.getRoleIds();
            /*删除该用户之前的角色*/
            UserRoleVo reqVo = new UserRoleVo();
            reqVo.setUserId(webUserReqVo.getId());
            userRoleDao.remove(reqVo);
            /*设置新角色*/
            for (String roleId : roleIds) {
                UserRoleVo userRoleRelation = new UserRoleVo();
                userRoleRelation.setRoleId(roleId);
                userRoleRelation.setUserId(webUserReqVo.getId());
                userRoleRelation.setId(StringHelper.getNewID());
                userRoleDao.create(userRoleRelation);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String updateUser(WebUserReqVo webUserReqVo) {
        com.pangding.web.vo.system.pd.authority.UserVo userVo = userDao.load(webUserReqVo.getId(), com.pangding.web.vo.system.pd.authority.UserVo.class);
        if (StringHelper.isEmpty(userVo)) {
            throw new CodeException("99", "没有找到用户信息");
        }
        if (1 != webUserReqVo.getUpdateType()) {
            this.isValid(webUserReqVo.getAccount());
            this.checkAccount(webUserReqVo);
            this.checkPhone(webUserReqVo);
            ObjectHelper.writeWithFrom(userVo, webUserReqVo);
        } else {
            userVo.setRemark(webUserReqVo.getPassword());
            userVo.setPassword(this.passwordEncoder(webUserReqVo.getPassword()));
        }
        userDao.update(userVo);
        if (StringHelper.isEmpty(webUserReqVo.getUpdateType())) {
            UserRoleGetReqVo reqVo = new UserRoleGetReqVo();
            reqVo.setUserId(webUserReqVo.getId());
            List<UserRoleVo> userRoleList = userRoleDao.getUserRoleList(reqVo);
            if (userRoleList != null && !userRoleList.isEmpty()) {
                List<String> userRoleIdList = new ArrayList(userRoleList.size());
                for (UserRoleVo userRole : userRoleList) {
                    userRoleIdList.add(userRole.getId());
                }
                if (userRoleIdList != null && !userRoleIdList.isEmpty()) {
                    for (String userRoleId : userRoleIdList) {
                        UserRoleRemoveReqVo userRole = new UserRoleRemoveReqVo();
                        userRole.setId(userRoleId);
                        userRoleDao.remove(userRole);
                    }
                }
            }
            saveUserRole(webUserReqVo);
        }
        return userVo.getId();
    }

    @Override
    public String updateUserInfo(UserReqVo req) {
        UserVo userVo = userDao.load(req.getId(), UserVo.class);
        if (!StringHelper.isEmpty(userVo)) {
            userVo.setReceiveFlag(req.getReceiveFlag());
            userDao.update(userVo);
        }
        return userVo.getId();
    }

    @Override
    public void checkAccount(UserVo userVo) {
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setAccount(userVo.getAccount());
        UserVo userVo1 = userDao.load(userGetReqVo, UserVo.class);
        if ((null != userVo1 && null == userVo.getId()) ||
                (null != userVo1 && null != userVo.getId() && !userVo1.getId().equals(userVo.getId()))) {
            throw new CodeException("用户名" + userVo.getAccount() + "已存在");
        }
    }

    @Override
    public void checkPhone(UserVo userVo) {
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setPhone(userVo.getPhone());
        UserVo userVo1 = userDao.load(userGetReqVo, UserVo.class);
        if ((!StringHelper.isEmpty(userVo1) && StringHelper.isEmpty(userVo.getId())) ||
                (!StringHelper.isEmpty(userVo1) && !StringHelper.isEmpty(userVo.getId()) && !userVo1.getId().equals(userVo.getId()))) {
            throw new CodeException("手机号" + userVo.getPhone() + "已存在");
        }
    }

    @Override
    public String passwordEncoder(String password) {
        return StringHelper.md5(password);
    }


    @Override
    public WebUserResVo makeResVo(UserVo userVo) {

        WebUserResVo resVo = new WebUserResVo();
        ObjectHelper.writeWithFrom(resVo, userVo);

        UserRoleGetReqVo reqVo = new UserRoleGetReqVo();
        reqVo.setUserId(userVo.getId());
        List<UserRoleVo> userRoleVoList = this.listUserRoleListByUserId(reqVo);
        if (userRoleVoList != null && !userRoleVoList.isEmpty()) {
            List<RoleVo> roleList = new ArrayList(userRoleVoList.size());
            for (UserRoleVo userRoleRelation : userRoleVoList) {
                String roleId = userRoleRelation.getRoleId();
                RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
                roleGetReqVo.setId(roleId);
                RoleVo roleVo = roleDao.load(roleGetReqVo, RoleVo.class);
                roleList.add(roleVo);
            }
            resVo.setRoleList(roleList);
        }

        return resVo;
    }

    @Override
    public WebUserResVo getUserById(String userId) {
        UserVo userVo = userDao.load(userId, UserVo.class);
        if (userVo == null) {
            throw new CodeException("该用户不存在");
        }
        WebUserResVo resVo = this.makeResVo(userVo);
        return resVo;
    }

    @Override
    public List<UserRoleVo> listUserRoleListByUserId(UserRoleGetReqVo reqVo) {
        return userRoleDao.getUserRoleList(reqVo);
    }

    @Override
    public RoleVo getRoleByRoleId(RoleGetReqVo roleGetReqVo) {
        return roleDao.getRoleById(roleGetReqVo);
    }

    @Override
    public Boolean isNumeric(String account) {
        for (int i = 0; i < account.length(); i++) {
            if (!Character.isDigit(account.charAt(i))) {
                return false;
            }
        }

        return true;
    }

    @Override
    public void isValid(String account) {
        String regex = "^(?!\\d+$)[\\da-zA-Z]+$";
        if (!account.matches(regex)) {
            throw new CodeException("错误的用户名：" + account + ",用户名仅支持字母和数字的组合，且不能为纯数字");
        }
    }

    @Override
    public void checkEmail(String email) {
        String regex = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$";
        if (!email.matches(regex)) {
            throw new CodeException("错误的邮箱格式：" + email);
        }
    }

    @Override
    public UserVo getUserByPhone(String phone) {
        UserGetReqVo reqVo = new UserGetReqVo();
        reqVo.setPhone(phone);
        return userDao.load(reqVo, UserVo.class);
    }

    @Override
    public UserVo getUserByAccount(String account) {
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setAccount(account);
        return userDao.load(userGetReqVo, UserVo.class);
    }

    @Override
    public PageSizeData<UserVo> getUserVoList(ListUserReqVo reqVo) {
        PageSizeData<UserVo> userVoPageSizeData = userDao.getUserVoList(reqVo);
        if (userVoPageSizeData.getList() == null || userVoPageSizeData.getList().isEmpty()) {
            throw new CodeException("没有更多用户");
        }
        return userVoPageSizeData;
    }

    @Override
    public PageSizeData<WebUserResVo> getWebUserResVoList(ListUserReqVo reqVo) {
        PageSizeData<WebUserResVo> webUserResVoPageSizeData = new PageSizeData();

        // 找到用户列表
        PageSizeData<UserVo> userVoPageSizeData = this.getUserVoList(reqVo);

        List<UserVo> userVoList = userVoPageSizeData.getList();
        // 找到用户角色列表
        List<WebUserResVo> webUserResVoList = new ArrayList(userVoList.size());
        for (UserVo userVo : userVoList) {
            WebUserResVo resVo = new WebUserResVo();
            List<RoleVo> roleVoList = this.getRoleListByUserId(userVo.getId());
            ObjectHelper.writeWithFrom(resVo, userVo);
            webUserResVoList.add(resVo);
        }
        webUserResVoPageSizeData.setPageTotal(webUserResVoPageSizeData.getPageTotal());
        webUserResVoPageSizeData.setList(webUserResVoList);
        webUserResVoPageSizeData.setPageIndex(webUserResVoPageSizeData.getPageIndex());
        webUserResVoPageSizeData.setPageSize(webUserResVoPageSizeData.getPageSize());
        return webUserResVoPageSizeData;
    }

    @Override
    public List<RoleVo> getRoleListByUserId(String userId) {
        UserRoleGetReqVo reqVo = new UserRoleGetReqVo();
        reqVo.setUserId(userId);
        List<UserRoleVo> userRoleVoList = userRoleDao.getUserRoleList(reqVo);
        if (userRoleVoList != null && !userRoleVoList.isEmpty()) {
            List<RoleVo> roleVoList = new ArrayList(userRoleVoList.size());
            for (UserRoleVo userRoleVo : userRoleVoList) {
                RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
                roleGetReqVo.setId(userRoleVo.getRoleId());
                RoleVo roleVo = roleDao.load(roleGetReqVo, RoleVo.class);
                roleVoList.add(roleVo);
            }
            return roleVoList;
        }
        return null;
    }

    /**
     * tangfang
     * 注册保存用户信息
     *
     * @param saveUserReqVo
     */


}
