package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.UserVo;
import com.pangding.web.authority.vo.reqvo.CountByRoleReqVo;
import com.pangding.web.authority.vo.reqvo.ListUserReqVo;
import com.pangding.web.authority.vo.reqvo.UserGetReqVo;
import com.pangding.web.authority.vo.reqvo.UserGetSuperAdminReqVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface UserDao extends BaseDao {


    /**
     * 检查用户名是否存在
     *
     * @param account 账户名
     * @return UserVo对象
     */
    void checkAccount(UserVo account);

    /**
     * 检查电话号码是否存在
     *
     * @param phone 电话号码
     */
    void checkPhone(UserVo phone);


    /**
     * 通过用户id查询UserVo对象
     *
     * @param reqVo 用户id
     * @return UserVo对象
     */
    UserVo getUser(UserGetReqVo reqVo);

    /**
     * 根据公司id获取UserVo对象
     *
     * @param companyId GetUserByCompanyIdReqVo请求对象，封装公司id
     * @return UserVo对象
     */
    UserVo getUserByCompanyId(UserGetReqVo companyId);

    /**
     * 获取用户分页对象
     *
     * @param reqVo
     * @return 用户分页对象
     */
    PageSizeData<UserVo> getUserVoList(ListUserReqVo reqVo);

    UserVo getSuperAdmin(UserGetSuperAdminReqVo reqVo);

    /**
     * 获取该公司该角色已分配的角色列表
     * @param reqVo 封装了公司id和权限id的请求对象
     * @return 用户列表
     */
    PageSizeData<UserVo> countByRole(CountByRoleReqVo reqVo);
}
