package com.pangding.web.authority.controller;

import com.pangding.web.vo.system.req.authority.SaveUserReqVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author  tf
 * 注册controller
 */
@RestController
@RequestMapping(value = "/register")
@Api(value = "注册类", description = "注册用户，新增用户")
public class RegisterController {

    @RequestMapping(value = "/saveUser")
    public ResponseResult saveUser(@RequestBody SaveUserReqVo req){
        CheckerHelper.newInstance().notBlankCheck("", req.getAccount())
                .notBlankCheck("", req.getPassword())
                .notBlankCheck("", req.getConfirmPassword())
                .notBlankCheck("", req.getInvitationCode())
                .notBlankCheck("", req.getCompanyType())
                .checkException();

        return ResponseResult.result("");
    }


}
