package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyMsgDao;
import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.service.CompanyMsgService;
import com.pangding.web.partner.mq.PartnerProcedure;
import com.pangding.web.partner.vo.req.SoundContentVo;
import com.pangding.web.vo.system.req.CompanyMsgReqVo;
import com.pangding.web.vo.system.req.authority.UserReqVo;
import com.pangding.web.vo.system.res.CompanyMsgResVo;
import com.pangding.web.vo.system.res.authority.UserResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CompanyMsgServiceImpl implements CompanyMsgService{

    @Autowired
    private CompanyMsgDao companyMsgDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PartnerProcedure partnerProcedure;


    @Override
    public PageSizeData<CompanyMsgResVo> findCompanyMsgList(CompanyMsgReqVo req){
        return companyMsgDao.findPageCompanyMsgList(req);
    }

    @Override
    public ResponseResult saveCompanyMsg(CompanyMsgReqVo reqVo){

        companyMsgDao.create(reqVo);

        SoundContentVo soundContentVo = new SoundContentVo();
        soundContentVo.setTipContent(reqVo.getMsgContent());
        soundContentVo.setTipSound(reqVo.getMsgSound());
        soundContentVo.setTipUrl("http://frapp.pangdly.com?msg=" + soundContentVo.getTipContent());

        UserReqVo userReqVo = new UserReqVo();
        userReqVo.setCompanyId(reqVo.getCompanyId());
        List<UserResVo> userResList = userDao.loadList(userReqVo, UserResVo.class);
        for(int i = 0; i < userResList.size(); i++){
            if(1 == userResList.get(i).getReceiveFlag()){
                partnerProcedure.sendSoundContent(userResList.get(i).getId(), soundContentVo);
            }
        }
        return ResponseResult.result("处理成功");
    }

}
