package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.AuthorityDao;
import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class AuthorityDaoImpl extends BaseDaoImpl implements AuthorityDao {

    private static final String CHECK_VALID = "CHECK_VALID";
    private static final String SELECT = "SELECT";
    private static final String GET_LEVEL_ONE = "GET_LEVEL_ONE";
    private static final String AFTER = "AFTER";
    private static final String LIST_BY_SORT = "LIST_BY_SORT";
    private static final String GET_LESS_BETWEEN = "GET_LESS_BETWEEN";
    private static final String GET_MORE_BETWEEN = "GET_MORE_BETWEEN";

    @Override
    protected void init() {
        register(AuthorityVo.class);

        table.addExist(CHECK_VALID,"name","url");

        table.add(SELECT,"select * from pd_authority where 1=1")
                .add("id","and pid = ? ")
                .add("pid","and pid = ? ")
                .add("sort","and sort = ? ")
                .add("search", "and (name like concat(?,'%') " +
                        "or alias like concat(?,'%')) " )
                .add("levelOne","and pid = '' order by sort asc");

        table.add(GET_LEVEL_ONE,"select * from pd_authority where 1=1 ")
                .add("attribute","and attribute = ?")
                .add("levelOne","and pid = '' order by sort asc");

        table.add(AFTER,"select * from pd_authority where 1=1 ")
                .add("pid","and pid = ? ")
                .add("sort","and sort >= ? ")
                .add("attribute","and attribute = ?");

        table.add(LIST_BY_SORT,"select * from pd_authority where 1=1 ")
                .add("pid","and pid = ? order by sort asc");

        table.add(GET_LESS_BETWEEN,"select * from pd_authority where 1=1 ")
                .add("pid","and pid = ?")
                .add("smallSort","and sort >= ?")
                .add("bigSort","and sort < ?")
                .add("attribute","and attribute = ?");

        table.add(GET_MORE_BETWEEN,"select * from pd_authority where 1=1")
                .add("pid","and pid = ?")
                .add("smallSort","and sort > ?")
                .add("bigSort","and sort <= ?")
                .add("attribute","and attribute = ?");
    }

    /**
     * 检查新建或修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     */
    @Override
    public void checkValid(AuthorityVo authorityVo) {
        this.checkExist(CHECK_VALID,authorityVo,"该权限不合法，请修改权限名或权限url");
    }

    /**
     * 获取权限分页对象
     *
     * @param reqVo
     * @return 权限分页对象
     */
    @Override
    public PageSizeData<AuthorityVo> getAuthorityList(ListAuthorityByPageReqVo reqVo) {
        return this.queryPage(AuthorityVo.class,reqVo,SELECT,reqVo);
    }

    @Override
    public List<AuthorityVo> getLevelOne(AuthorityListReqVo reqVo) {
        return this.query(AuthorityVo.class,GET_LEVEL_ONE,reqVo);
    }

    @Override
    public List<AuthorityVo> after(AuthorityAfterReqVo afterReqVo) {
        return this.query(AuthorityVo.class,AFTER,afterReqVo);
    }

    @Override
    public List<AuthorityVo> listBySort(AuthorityGetReqVo reqVo) {
        return this.query(AuthorityVo.class,LIST_BY_SORT,reqVo);
    }

    @Override
    public List<AuthorityVo> getLessBetween(AuthorityBetweenSortReqVo reqVo) {
        return this.query(AuthorityVo.class,GET_LESS_BETWEEN,reqVo);
    }

    @Override
    public List<AuthorityVo> getMoreBetween(AuthorityBetweenSortReqVo reqVo) {
        return this.query(AuthorityVo.class,GET_MORE_BETWEEN,reqVo);
    }
}
