package com.pangding.web.tright.dao;

import com.pangding.web.tright.vo.GetRoleByRoleIdReqVo;
import com.pangding.web.tright.vo.GetRoleByRoleNameReqVo;
import com.pangding.web.tright.vo.RoleVo;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface RoleDao extends BaseDao {

    /**
     * 通过主键id获取RoleVo对象
     *
     * @param getRoleByRoleIdReqVo getRoleByRoleIdReqVo对象
     * @return  RoleVo对象
     */
    RoleVo getRoleById(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo);

    /**
     * 通过角色名查询RoleVo对象
     *
     * @param getRoleByRoleNameReqVo 角色名
     * @return RoleVo对象
     */
    RoleVo getRoleByRoleName(GetRoleByRoleNameReqVo getRoleByRoleNameReqVo);

    /**
     * 检查用户名是否已存在
     * 若返回数据大于0，则已存在，该用户名不可用
     * 为0则可用
     *
     * @param roleVo 需要检查的RoleVo对象
     * @return RoleVo对象的用户名在数据库中是否使用过
     */
    int checkNameExist(RoleVo roleVo);

    /**
     * 获取RoleVo对象列表
     *
     * @return RoleVo对象列表
     */
    List<RoleVo> getRoleVoList();

    /**
     * 通过角色id查询该角色具有的权限id列表
     *
     * @param roleId 角色id
     * @return 权限id列表
     */
    List<String> getTrightIdList(String roleId);

    /**
     * 通过权限id查询权限名
     * 
     * @param trightId 权限id
     * @return 权限名
     */
    String getTrightNameByTrightId(String trightId);

}
