package com.pangding.web.tright.dao.impl;

import com.pangding.web.tright.dao.RoleDao;
import com.pangding.web.tright.vo.GetRoleByRoleIdReqVo;
import com.pangding.web.tright.vo.GetRoleByRoleNameReqVo;
import com.pangding.web.tright.vo.RoleVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import javax.management.relation.Role;
import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class RoleDaoImpl extends BaseDaoImpl implements RoleDao {

    private static final String GET_ROLE_BY_ID = "GET_ROLE_BY_ID";
    private static final String GET_ROLE_BY_NAME = "GET_ROLE_BY_NAME";
    private static final String CHECK_NAME_EXIST = "CHECK_NAME_EXIST";
    private static final String GET_ROLELIST = "GET_ROLEDTO_LIST";
    private static final String GET_TRIGHTID_LIST = "GET_TRIGHTID_LIST";
    private static final String GET_TRIGHTNAME_BY_TRIGHTID = "GET_TRIGHTNAME_BY_TRIGHTID";

    @Override
    protected void init() {
        register(RoleVo.class);

        table.add(CHECK_NAME_EXIST,"select count(r.id) from pd_role r where 1=1 ")
        .add("name","and r.name = ? ")
        .add("id","and r.id <> ?");

        table.add(GET_ROLELIST,"select * from pd_role where 1=1");

        table.add(GET_TRIGHTID_LIST,"select authority_id from pd_role_authority where 1=1 ")
        .add("roleId","and role_id = ?");

        table.add(GET_TRIGHTNAME_BY_TRIGHTID,"select name from pd_authority where 1=1 ")
        .add("trightId","and id = ?");

    }

    @Override
    public RoleVo getRoleById(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo) {
        return this.load(getRoleByRoleIdReqVo,RoleVo.class);
    }

    @Override
    public RoleVo getRoleByRoleName(GetRoleByRoleNameReqVo getRoleByRoleNameReqVo) {
        return this.load(getRoleByRoleNameReqVo, RoleVo.class);
    }

    @Override
    public int checkNameExist(RoleVo roleVo) {
        return this.queryFirst(int.class,CHECK_NAME_EXIST,roleVo);
    }

    @Override
    public List<RoleVo> getRoleVoList() {
        return this.query(RoleVo.class,GET_ROLELIST,null);
    }

    @Override
    public List<String> getTrightIdList(String roleId) {
        return this.query(String.class,GET_TRIGHTID_LIST,roleId);
    }

    @Override
    public String getTrightNameByTrightId(String trightId) {
        return this.queryFirst(String.class,GET_TRIGHTNAME_BY_TRIGHTID,trightId);
    }
}
