package com.pangding.web.tright.dao.impl;

import com.pangding.web.tright.dao.RoleTrightDao;
import com.pangding.web.tright.vo.RoleTrightRelation;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class RoleTrightDaoImpl extends BaseDaoImpl implements RoleTrightDao {

    private static final String GET_ROLE_TRIGHT_PKLIST_BY_ROLEID = "GET_ROLE_TRIGHT_PKLIST_BY_ROLEID";
    private static final String GET_ROLE_TRIGHT_PKLIST_BY_TRIGHTID = "GET_ROLE_TRIGHT_PKLIST_BY_TRIGHTID";

    @Override
    protected void init() {

        register(RoleTrightRelation.class);

        table.add(GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,"select id from pd_role_authority where 1=1 ")
        .add("roleId","and role_id = ?");

        table.add(GET_ROLE_TRIGHT_PKLIST_BY_TRIGHTID,"select id from pd_role_authority where 1=1 ")
        .add("trightId","and tright_id = ?");
    }

    @Override
    public List<String> getRoleTrightPKListByRoleId(String roleId) {

        return this.query(String.class,GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,roleId);
    }

    @Override
    public List<String> getRoleTrightPKListByTrightId(String trightId) {
        return this.query(String.class,GET_ROLE_TRIGHT_PKLIST_BY_TRIGHTID,trightId);
    }
}
