package com.pangding.web.tright.dao.impl;

import com.pangding.web.tright.dao.TrightDao;
import com.pangding.web.tright.vo.TrightVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;
/**
 * @author zhangjinyao
 */
@Component
public class TrightDaoImpl extends BaseDaoImpl implements TrightDao {

    private static final String CHECK_VALID = "CHECK_VALID";
    private static final String GET_TRIGHT_BY_ID = "GET_TRIGHT_BY_ID";
    private static final String LIST_ALL = "LIST_ALL";
    private static final String LIST_LEVEL_ONE = "LIST_LEVEL_ONE";
    private static final String CHECK_CHILD = "CHECK_CHILD";
    private static final String GET_CHILDID_LIST = "GET_CHILDID_LIST";

    @Override
    protected void init() {
        register(TrightVo.class);

        table.add(CHECK_VALID,"select count(a.id) from pd_authority a where 1=1 ")
        .add("name","and a.name = ? ")
        .add("url","and a.url = ? ")
        .add("id","and a.id <> ?");

        table.add(GET_TRIGHT_BY_ID,"select * from pd_authority where 1=1 ")
        .add("id","and id = ?");

        table.add(LIST_ALL,"select * from pd_authority where 1=1");

        table.add(LIST_LEVEL_ONE,"select * from pd_authority where pid=null");

        table.add(CHECK_CHILD,"select count(id) from pd_authority where 1=1 ")
        .add("id","and pid = ?");

        table.add(GET_CHILDID_LIST,"select id from pd_authority where 1=1 ")
        .add("id","and pid = ?");
    }

    @Override
    public int checkValid(TrightVo trightVo) {
        return this.queryFirst(int.class,CHECK_VALID,trightVo);
    }

    @Override
    public TrightVo getTrightById(String id) {
        return this.queryFirst(TrightVo.class,GET_TRIGHT_BY_ID,id);
    }

    @Override
    public List<TrightVo> listAll() {

        return this.query(TrightVo.class,LIST_ALL,null);
    }

    @Override
    public List<TrightVo> listLevel1() {

        return this.query(TrightVo.class,LIST_LEVEL_ONE,null);
    }

    @Override
    public int checkChild(String id) {
        return this.queryFirst(int.class,CHECK_CHILD,id);
    }

    @Override
    public List<String> getChildIdList(String id) {
        return this.query(String.class,GET_CHILDID_LIST,id);
    }
}
