package com.pangding.web.tright.dao.impl;

import com.pangding.web.tright.dao.UserDao;
import com.pangding.web.tright.vo.GetUserByAccountReqVo;
import com.pangding.web.tright.vo.GetUserByIdReqVo;
import com.pangding.web.tright.vo.UserVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class UserDaoImpl extends BaseDaoImpl implements UserDao {


    private static final String SELECT = "SELECT";
    private static final String DELETE_USER_ROLE="deleteUserRole";
    private static final String SAVE_USER_ROLE = "saveUserRoles";
    private static final String GET_ALL_USERS = "GET_ALL_USERS";
    private static final String GET_ROLE_IDS = "GET_ROLE_IDS";
    private static final String GET_USER_BY_ID = "GET_USER_BY_ID";
    private static final String GET_ROLE_BY_ROLEID = "GET_ROLE_BY_ROLEID";

    @Override
    protected void init() {
        register(UserVo.class);

        table.add(GET_ALL_USERS,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1");

    }

    @Override
    public UserVo getUserByAccount(GetUserByAccountReqVo account) {
        return this.load(account,UserVo.class);
    }


    @Override
    public List<UserVo> listUserVo() {

        return this.query(UserVo.class,GET_ALL_USERS,null);

    }

    @Override
    public List<String> getRoleIdList(UserVo userVo) {
        return this.query(String.class,GET_ROLE_IDS,userVo);
    }

    @Override
    public String getRoleNameByRoleId(String roleId) {
        return this.queryFirst(String.class,GET_ROLE_BY_ROLEID,roleId);
    }

    @Override
    public UserVo getUserById(GetUserByIdReqVo id) {
        return this.load(id,UserVo.class);
    }
}
