package com.pangding.web.tright.service;

import com.pangding.web.tright.vo.TrightVo;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface TrightService {
    /**
     * 保存TrightVo对象数据
     *
     * @param trightVo TrightVo对象
     */
    void save(TrightVo trightVo);

    /**
     * 更新TrightVo对象数据
     *
     * @param trightVo TrightVo对象
     */
    void update(TrightVo trightVo);

    /**
     * 通过权限表主键获取TrightVo对象
     *
     * @param id 主键
     * @return TrightVo对象
     */
    TrightVo getTrightById(String id);

    /**
     * 通过权限表主键删除TrightVo对象，并删除权限和角色的对应关系
     *
     * @param id 主键
     */
    void deleteTrightById(String id);

    /**
     * 检查新建、修改的TrightVo对象是否合法
     *
     * @param trightVo TrightVo对象
     * @return 0：合法 else：不合法
     */
    Boolean checkValid(TrightVo trightVo);

    /**
     * 获取TrightVo对象列表
     *
     * @return TrightVo对象列表
     */
    List<TrightVo> listAllTright();

    /**
     * 获取一级权限列表
     *
     * @return 一级权限列表
     */
    List<TrightVo> listLevel1();

    /**
     * 通过权限id查询是否存在子权限
     *
     * @param id 权限id
     * @return 是否存在子权限
     */
    Boolean checkChild(String id);

    /**
     * 通过权限id获取子权限id列表
     *
     * @param id 权限id
     * @return 子权限id列表
     */
    List<String> getChildIdList(String id);

}
