package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.RoleDao;
import com.pangding.web.tright.dao.RoleTrightDao;
import com.pangding.web.tright.dao.UserRoleDao;
import com.pangding.web.tright.dto.RoleDto;
import com.pangding.web.tright.service.RoleService;
import com.pangding.web.tright.vo.GetRoleByRoleNameReqVo;
import com.pangding.web.tright.vo.RoleTrightRelation;
import com.pangding.web.tright.vo.RoleVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.UUID;

/**
 * @author zhangjinyao
 */
@Service
public class RoleServiceImpl implements RoleService {

    @Autowired
    RoleDao roleDao;

    @Autowired
    UserRoleDao userRoleDaoImpl;

    @Autowired
    RoleTrightDao roleTrightDaoImpl;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveRole(RoleDto roleDto) {
        RoleVo roleVo = roleDto;
        roleDao.create(roleVo);
        List<String> trightIds = roleDto.getTrightIds();
        for (String trightId : trightIds) {
            RoleTrightRelation roleTrightRelation = new RoleTrightRelation();
            roleTrightRelation.setTrightId(trightId);
            roleTrightRelation.setRoleId(roleDto.getId());
            roleTrightRelation.setId(UUID.randomUUID().toString().replace("-",""));
            roleTrightDaoImpl.create(roleTrightRelation);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateRole(RoleDto roleDto) {
        RoleVo roleVo = roleDto;
        roleDao.update(roleVo);
        List<String> roleTrightIdList = roleTrightDaoImpl.getRoleTrightPKListByRoleId(roleDto.getId());
        if (roleTrightIdList != null && roleTrightIdList.size() != 0){
            for (String roleTrightId:roleTrightIdList) {
                roleTrightDaoImpl.remove(roleTrightId);
            }
        }
        List<String> trightIds = roleDto.getTrightIds();
        for (String trightId : trightIds) {
            RoleTrightRelation roleTrightRelation = new RoleTrightRelation();
            roleTrightRelation.setTrightId(trightId);
            roleTrightRelation.setRoleId(roleDto.getId());
            roleTrightRelation.setId(UUID.randomUUID().toString().replace("-",""));
            roleTrightDaoImpl.update(roleTrightRelation);
        }
    }

    @Override
    public RoleVo getRoleById(String id) {
        return roleDao.getRoleById(id);
    }

    @Override
    public RoleVo getRoleByName(String name) {
        GetRoleByRoleNameReqVo getRoleByRoleNameReqVo = new GetRoleByRoleNameReqVo();
        getRoleByRoleNameReqVo.setName(name);
        return roleDao.getRoleByRoleName(getRoleByRoleNameReqVo);
    }

    @Override
    public Boolean checkNameExist(RoleVo roleVo) {
        if (roleDao.checkNameExist(roleVo) > 0){return false;}
        return true;
    }

    @Override
    public List<RoleVo> getRoleVoList() {
        return roleDao.getRoleVoList();
    }

    @Override
    public List<String> getTrightIdList(String roleId) {
        return roleDao.getTrightIdList(roleId);
    }

    @Override
    public String getTrightNameByTrightId(String trightId) {
        return roleDao.getTrightNameByTrightId(trightId);
    }

    @Override
    public RoleDto makeRoleDto(RoleVo roleVo, List<String> trightIdList, List<String> trightNameList) {
        RoleDto roleDto = (RoleDto) roleVo;
        roleDto.setTrightIds(trightIdList);
        roleDto.setTrightNames(trightNameList);
        return roleDto;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteRole(String roleId) {

        roleDao.remove(roleId);
        List<String> roleUserList = userRoleDaoImpl.getRoleUserPKListByRoleId(roleId);
        for (String roleUserId:roleUserList) {
            if (roleUserId != null && roleUserId != "") {
                userRoleDaoImpl.remove(roleUserId);
            }
        }
        List<String> roleTrightList = roleTrightDaoImpl.getRoleTrightPKListByRoleId(roleId);
        for (String roleTrightId:roleTrightList) {
            if (roleTrightId != null && roleTrightId != "") {
                roleTrightDaoImpl.remove(roleTrightId);
            }
        }
    }
}
