package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.RoleDao;
import com.pangding.web.tright.dao.UserDao;
import com.pangding.web.tright.dao.UserRoleDao;
import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.service.UserService;
import com.pangding.web.tright.utils.Md5AndSalt;
import com.pangding.web.tright.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * @author zhangjinyao
 */
@Service
public class UserServiceImpl implements UserService {

    @Autowired
    UserDao userDao;

    @Autowired
    UserRoleDao userRoleDao;

    @Autowired
    RoleDao roleDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveUser(UserDto userDto) {
        UserVo userVo = userDto;
        userDao.create(userVo);
        if (userDto.getRoleIds()!=null&&userDto.getRoleIds().size()!=0){
            List<String> roleIds = userDto.getRoleIds();
            for (String roleId : roleIds) {
                UserRoleRelation userRoleRelation = new UserRoleRelation();
                userRoleRelation.setRoleId(roleId);
                userRoleRelation.setUserId(userDto.getId());
                userRoleRelation.setId(UUID.randomUUID().toString().replace("-",""));
                userRoleDao.create(userRoleRelation);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateUser(UserDto userDto) {
        UserVo userVo = userDto;
        userDao.update(userVo);
        GetUserRoleListByUserIdReqVo userId = new GetUserRoleListByUserIdReqVo();
        userId.setUserId(userDto.getId());
        List<UserRoleRelation> userRoleList = userRoleDao.getUserRoleListByUserId(userId);
        List<String> userRoleIdList = new ArrayList(userRoleList.size());
        for (UserRoleRelation userRole:userRoleList) {
            userRoleIdList.add(userRole.getId());
        }
        if (userRoleIdList != null && userRoleIdList.size() != 0){
            for (String userRoleId:userRoleIdList){
                UserRoleDaoRemoveReqVo userRole = new UserRoleDaoRemoveReqVo();
                userRole.setId(userRoleId);
                userRoleDao.remove(userRole);
            }
        }
        if (userDto.getRoleIds()!=null&&userDto.getRoleIds().size()!=0){
            List<String> roleIds = userDto.getRoleIds();
            for (String roleId : roleIds) {
                UserRoleRelation userRoleRelation = new UserRoleRelation();
                userRoleRelation.setRoleId(roleId);
                userRoleRelation.setUserId(userDto.getId());
                userRoleRelation.setId(UUID.randomUUID().toString().replace("-",""));
                userRoleDao.create(userRoleRelation);
            }
        }
    }

    @Override
    public List<UserVo> listUserVo() {

        return userDao.listUserVo();
    }

    @Override
    public UserVo getUser(UserVo userVo) {
        GetUserByAccountReqVo account = new GetUserByAccountReqVo();
        account.setAccount(userVo.getAccount());
        return userDao.getUserByAccount(account);
    }

    @Override
    public String passwordEncoder(String password) { return Md5AndSalt.generate(password); }


    @Override
    public UserDto makeUserDto(UserVo userVo, List<String> roleIdList, List<String> roleNameList) {
        UserDto userDto = new UserDto();
        userDto.setPassword(userVo.getPassword());
        userDto.setAccount(userVo.getAccount());
        userDto.setCreateTime(userVo.getCreateTime());
        userDto.setCreator(userVo.getCreator());
        userDto.setId(userVo.getId());
        userDto.setPhone(userVo.getPhone());
        userDto.setRemark(userVo.getRemark());
        userDto.setStatus(userVo.getStatus());
        userDto.setRoleIds(roleIdList);
        userDto.setRoles(roleNameList);
        return userDto;
    }

    @Override
    public UserVo getUserById(String userId) {
        GetUserByIdReqVo id = new GetUserByIdReqVo();
        id.setId(userId);
        return userDao.getUserById(id);
    }

    @Override
    public List<UserRoleRelation> listUserRoleListByUserId(GetUserRoleListByUserIdReqVo reqVo) {
        return userRoleDao.getUserRoleListByUserId(reqVo);
    }

    @Override
    public RoleVo getRoleByRoleId(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo) {
        return roleDao.getRoleById(getRoleByRoleIdReqVo);
    }
}
