package com.pangding.web.authority.service;

import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.ListAuthorityReqVo;
import com.pangding.web.authority.vo.reqvo.WebAuthorityReqVo;
import com.pangding.web.authority.vo.reqvo.WebAuthorityResVo;
import com.pangding.web.authority.vo.reqvo.WebUserResVo;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface AuthorityService {
    /**
     * 保存authorityVo对象数据
     *
     * @param authorityVo authorityVo对象
     */
    void save(AuthorityVo authorityVo);

    /**
     * 更新authorityVo对象数据
     *
     * @param authorityVo authorityVo对象
     */
    void update(AuthorityVo authorityVo);

    /**
     * 通过权限表主键获取authorityVo对象
     *
     * @param reqVo 主键
     * @return authorityVo对象
     */
    AuthorityVo getAuthorityById(WebAuthorityReqVo reqVo);

    /**
     * 通过权限表主键删除authorityVo对象，并删除权限和角色的对应关系
     *
     * @param reqVo 主键
     */
    void deleteAuthorityById(WebAuthorityReqVo reqVo);

    /**
     * 检查新建、修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     * @return 0：合法 else：不合法
     */
    void checkValid(AuthorityVo authorityVo);


    /**
     * 获取权限返回信息分页对象
     *
     * @param reqVo
     * @return 权限返回信息分页对象
     */
    PageSizeData<WebAuthorityResVo> getWebAuthorityResVoList(ListAuthorityReqVo reqVo);

}
