package com.pangding.web.authority.service.company.impl;

import com.pangding.web.authority.dao.CompanyRuleDao;
import com.pangding.web.authority.service.company.CompanyRuleService;
import com.pangding.web.vo.system.pd.company.CompanyRuleVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class CompanyRuleServiceImpl implements CompanyRuleService {

    @Autowired
    private CompanyRuleDao companyRuleDao;

    @Transactional(rollbackFor = Exception.class)
    public void saveCompanyRule(List<CompanyRuleVo> companyRuleVoList, String companyId) {
        // 删除现有的规则
//        CompanyRuleVo delCompanyRuleVo = new CompanyRuleVo();
//        delCompanyRuleVo.setCompanyId(companyId);
//        companyRuleDao.remove(delCompanyRuleVo);
        if (!StringHelper.isEmpty(companyRuleVoList) && companyRuleVoList.size() > 0) {
            for (int i = 0; i < companyRuleVoList.size(); i++) {
                CompanyRuleVo companyRuleVo = companyRuleVoList.get(i);
                // 主键为空 生成主键
                if (StringHelper.isEmpty(companyRuleVo.getCompanyRuleId())) {
                    companyRuleVo.setCompanyRuleId(StringHelper.getNewID());
                }
                // 查询该规则是否存在
                CompanyRuleVo sqlCompanyRuleVo = companyRuleDao.load(companyRuleVo.getCompanyRuleId(), CompanyRuleVo.class);
                if (StringHelper.isEmpty(sqlCompanyRuleVo)) {
                    sqlCompanyRuleVo = new CompanyRuleVo();
                    ObjectHelper.writeWithFromClass(sqlCompanyRuleVo, companyRuleVo);
                    sqlCompanyRuleVo.setCompanyId(companyId);
                    sqlCompanyRuleVo.setCompanyRuleId(StringHelper.getNewID());
                    companyRuleDao.create(sqlCompanyRuleVo);
                } else {
                    ObjectHelper.writeWithFromClass(sqlCompanyRuleVo, companyRuleVo);
                    sqlCompanyRuleVo.setUpdateDate(DateHelper.getNow());
                    companyRuleDao.update(sqlCompanyRuleVo);
                }
            }
        }
    }

}
