package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.vo.CompanyDivideRuleVo;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.reqvo.CompanyDivideReqVo;
import com.pangding.web.authority.vo.reqvo.ListCompanyReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:25
 */
@Component
public class CompanyDaoImpl extends BaseDaoImpl implements CompanyDao {

    private static final String CHECK_PHONE = "CHECK_PHONE";
    private static final String SELECT = "SELECT";
    private static final String QUERY_COMPANY_DIVIDE = "QUERY_COMPANY_DIVIDE";

    @Override
    protected void init() {

        register(CompanyVo.class);

        table.addExist(CHECK_PHONE,"contact_phone");

        table.add(SELECT,"select * from pd_company where 1=1 ")
                .add("companyName","and company_name = ? ")
                .add("companyType","and company_type = ? ")
                .add("companyAttribute","and company_attribute = ? ")
                .add("examineStatus","and examine_status = ?")
                .add("companyId","and pid = ? ");

        table.add(QUERY_COMPANY_DIVIDE, "select c.id as comanyId,c.company_name,ce.divide_status,cd.* from pd_company c " +
                "left join pd_company_extend ce on c.id = ce.id left join pd_company_divide_rule cd on c.id = cd.company_id " +
                "where c.examine_status = 1 ")
        .add("companyId", "and c.id = ? ");
    }

    @Override
    public void checkPhone(CompanyVo companyVo) {
        this.checkExist(CHECK_PHONE,companyVo,"电话号码已存在");
    }

    @Override
    public PageSizeData<CompanyVo> getCompanyList(ListCompanyReqVo reqVo) {
        return this.queryPage(CompanyVo.class,reqVo,SELECT,reqVo);
    }

    @Override
    public CompanyDivideRuleVo findCompanyDivideInfo(CompanyDivideReqVo req){
        return this.queryFirst(CompanyDivideRuleVo.class, QUERY_COMPANY_DIVIDE, req);
    }
}
