package com.pangding.web.tright.dao;

import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.vo.UserRoleRelation;
import com.pangding.web.tright.vo.UserVo;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface UserDao extends BaseDao {


    /**
     * 通过UserVo对象获取相同的UserVo对象
     *
     * @param userVo UserVo对象
     * @return UserVo对象
     */
    UserVo getUser(UserVo userVo);

    /**
     * 获取UserVo对象列表
     *
     * @return UserVo对象列表
     */
    List<UserVo> listUserVo();

    /**
     * 通过UserVo对象获取该用户角色id列表
     *
     * @param userVo UserVo对象
     * @return 角色id列表
     */
    List<String> getRoleIdList(UserVo userVo);

    /**
     * 通过角色id获取角色名
     *
     * @param roleId 角色id
     * @return 角色名
     */
    String getRoleNameByRoleId(String roleId);

    /**
     * 通过用户id查询UserVo对象
     *
     * @param userId 用户id
     * @return UserVo对象
     */
    UserVo getUserById(String userId);
}
