package com.pangding.web.authority.controller;

import com.pangding.web.authority.currency.Result;
import com.pangding.web.authority.dto.MobileRegisterCompanyDto;
import com.pangding.web.authority.dto.MobileRegisterUserDto;
import com.pangding.web.authority.dto.MobileRegisterUserReturnDto;
import com.pangding.web.authority.service.MobileRegisterService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.utils.Md5AndSalt;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.UserVo;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 11:26
 */
@RestController
@RequestMapping(value="/mobileRegister")
public class MobileRegisterController {

    @Autowired
    MobileRegisterService mobileRegisterServiceImpl;
    @Autowired
    UserService userServiceImpl;

    @RequestMapping(value = "/user", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveUser(@RequestBody MobileRegisterUserDto registerUserDto){

        if (!registerUserDto.getCompanyType().equals("个体")){
            return new Result(4001,"目前仅支持个体用户",registerUserDto);
        }

        UserVo userVo = new UserVo();
        userVo.setAccount(registerUserDto.getAccount());
        userServiceImpl.checkAccount(userVo);

        String merchantId = registerUserDto.getMerchantId();
        if (!mobileRegisterServiceImpl.checkMerchantId(merchantId)){
            return new Result(4001,"注册编码错误",registerUserDto);
        }

        String companyId = StringHelper.getNewID();
        userVo.setPassword(Md5AndSalt.generate(registerUserDto.getPassword()));
        userVo.setId(StringHelper.getNewID());
        userVo.setRemark(registerUserDto.getPassword());
        userVo.setCompanyId(companyId);
        mobileRegisterServiceImpl.saveUser(userVo);
        MobileRegisterUserReturnDto returnDto = new MobileRegisterUserReturnDto();
        returnDto.setCompanyId(companyId);
        returnDto.setMerchantId(merchantId);
        returnDto.setCompanyType(registerUserDto.getCompanyType());
        return new Result(0,"SUCCESS",returnDto);
    }

    @RequestMapping(value="company")
    public Object saveCompany(@RequestBody MobileRegisterCompanyDto companyDto){

        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(companyDto.getCompanyId());

        return null;
    }
}
