package com.tcm.common.service.impl;

import com.tcm.common.dao.TcmEnumDao;
import com.tcm.common.service.TcmEnumService;
import com.tcm.util.common.TcmEnumVo;
import com.tcm.util.common.req.TcmEnumLoadPageReqVo;
import com.tcm.util.common.req.TcmEnumReqVo;
import com.tcm.util.common.res.TcmEnumResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class TcmEnumServiceImpl implements TcmEnumService {

    private final TcmEnumDao tcmEnumDao;

    public TcmEnumServiceImpl(TcmEnumDao tcmEnumDao) {
        this.tcmEnumDao = tcmEnumDao;
    }

    @Override
    public String save(TcmEnumReqVo req) {
        if (StringHelper.isEmpty(req.getEnumId())) {
            //新增
            TcmEnumVo tcmEnumVo = new TcmEnumVo();
            String enumId = StringHelper.getNewID();
            tcmEnumVo.setEnumId(enumId);
            ObjectHelper.writeWithFrom(tcmEnumVo, req);
            tcmEnumVo.setCreateTime(DateHelper.getNow());
            tcmEnumDao.save(tcmEnumVo);
            return enumId;
        } else {
            //修改
            TcmEnumVo tcmEnumVo = new TcmEnumVo();
            tcmEnumVo.setEnumId(req.getEnumId());
            TcmEnumVo load = tcmEnumDao.load(tcmEnumVo, TcmEnumVo.class);
            ObjectHelper.writeWithFrom(load, req);
            tcmEnumDao.update(load);
            return req.getEnumId();
        }
    }

    @Override
    public TcmEnumResVo load(TcmEnumReqVo req) {
        TcmEnumVo tcmEnumVo = new TcmEnumVo();
        tcmEnumVo.setEnumId(req.getEnumId());
        return tcmEnumDao.load(tcmEnumVo, TcmEnumResVo.class);
    }

    @Override
    public PageSizeData<TcmEnumResVo> loadPage(TcmEnumLoadPageReqVo req) {
        PageSizeData<TcmEnumResVo> page = tcmEnumDao.loadPage(req, TcmEnumResVo.class);
        return page;
    }

    @Override
    public String remove(TcmEnumReqVo req) {
        TcmEnumVo tcmEnumVo = new TcmEnumVo();
        tcmEnumVo.setEnumId(req.getEnumId());
        tcmEnumDao.remove(tcmEnumVo);
        return req.getEnumId();
    }
}
