package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.vo.UserVo;
import com.pangding.web.authority.vo.reqvo.ListUserReqVo;
import com.pangding.web.authority.vo.reqvo.UserGetReqVo;
import com.pangding.web.authority.vo.reqvo.UserGetSuperAdminReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class UserDaoImpl extends BaseDaoImpl implements UserDao {


    private static final String SELECT = "SELECT";
    private static final String CHECK_ACCOUNT = "CHECK_ACCOUNT";
    private static final String CHECK_PHONE = "CHECK_PHONE";
    private static final String GET_SUPER_ADMIN = "GET_SUPER_ADMIN";

    @Override
    protected void init() {
        register(UserVo.class);

        table.add(SELECT,"select * from pd_user where 1=1");

        table.addExist(CHECK_ACCOUNT,"account");

        table.addExist(CHECK_PHONE,"phone");

        table.add(GET_SUPER_ADMIN,"SELECT u.* FROM pd_user u,pd_user_role ur WHERE u.id = ur.user_id")
                .add("superAdminRoleId","and ur.role_id = ?")
                .add("companyId","and u.company_id = ? ");

    }

    @Override
    public void checkAccount(UserVo account) {
        this.checkExist(CHECK_ACCOUNT,account,"用戶名已存在:"+account.getAccount());
    }

    @Override
    public void checkPhone(UserVo phone) {
        this.checkExist(CHECK_PHONE,phone,"手机号已存在:"+phone.getPhone());
    }

    @Override
    public UserVo getUser(UserGetReqVo reqVo) {
        return this.load(reqVo,UserVo.class);
    }

    @Override
    public UserVo getUserByCompanyId(UserGetReqVo companyId) {
        return this.load(companyId,UserVo.class);
    }

    @Override
    public PageSizeData<UserVo> getUserVoList(ListUserReqVo reqVo) {
        return this.queryPage(UserVo.class,reqVo,SELECT,reqVo);
    }

    @Override
    public UserVo getSuperAdmin(UserGetSuperAdminReqVo reqVo) {
        return this.queryFirst(UserVo.class,GET_SUPER_ADMIN,reqVo);
    }
}
