package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公司controller
 * @author tangfang
 * @date 2019-05-20 10:49
 */
@RestController
@RequestMapping(value="/company")
public class CompanyController {

    @Autowired
    CompanyService companyServiceImpl;


    /**y
     * 新增/修改公司信息
     * @param reqVo 公司以及公司扩展表信息
     * @return 公司信息
     */
    @RequestMapping(value = "/saveCompany", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<CompanyVo> saveCompany(@RequestBody CompanyAndCompanyExtendSaveReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyName",reqVo.getCompanyName())
                .notBlankCheck("companyType",reqVo.getCompanyType())
                .notBlankCheck("businessLicenseCode",reqVo.getBusinessLicenseCode())
                .notBlankCheck("address",reqVo.getAddress())
                .notBlankCheck("companyAttribute",reqVo.getCompanyAttribute())
                .notBlankCheck("contactName",reqVo.getContactName())
                .notBlankCheck("contactPhone",reqVo.getContactPhone())
                .checkPhoneNo("contactPhone",reqVo.getContactPhone())
                .notBlankCheck("contactCode",reqVo.getContactCode())
                .checkIdCard("contactCode",reqVo.getContactCode())
                .notBlankCheck("electromicAgreementCode",reqVo.getElectromicAgreementCode())
                .notBlankCheck("signingStatus",reqVo.getSigningStatus())
                .notBlankCheck("status",reqVo.getStatus())
                .notBlankCheck("nature",reqVo.getNature())
                .checkException();
        return ResponseResult.result(companyServiceImpl.saveCompany(reqVo));
    }

    /**y
     * 保存银行卡信息，并调用第三方接口发送手机验证码
     *
     * @param reqVo 公司银行卡表信息
     * @return 银行卡表主键
     */
    @RequestMapping(value = "/saveBank", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> saveBank(@RequestBody CompanyBankCardVo reqVo){
        checkBank(reqVo);
        return ResponseResult.result(companyServiceImpl.saveBank(reqVo));
    }

    private void checkBank(CompanyBankCardVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("bankCardCode",reqVo.getBankCardCode())
                .notNumberCheck("bankCardCode",reqVo.getBankCardCode())
                .notBlankCheck("bankName",reqVo.getBankName())
                .notBlankCheck("bankAddress",reqVo.getBankAddress())
                .notBlankCheck("bankCode",reqVo.getBankCode())
                .notBlankCheck("type",reqVo.getType())
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .notBlankCheck("name",reqVo.getName())
                .notBlankCheck("idCard",reqVo.getIdCard())
                .checkIdCard("idCard",reqVo.getIdCard())
                .notBlankCheck("reservedPhone",reqVo.getReservedPhone())
                .checkPhoneNo("reservedPhone",reqVo.getReservedPhone())
                .notBlankCheck("bindingCode",reqVo.getBindingCode())
                .notBlankCheck("bindingTime",reqVo.getBindingTime())
                .checkException();
    }

    /**y
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     * @param reqVo 银行卡表数据+验证码
     * @return 目前返回验证码
     */
    @RequestMapping(value = "/bankSubmit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> bankSubmit(@RequestBody BankSubmitReqVo reqVo){
        checkBank(reqVo);
        CheckerHelper.newInstance()
                .notBlankCheck("verifyCode",reqVo.getVerifyCode())
                .checkException();
        return ResponseResult.result(companyServiceImpl.bankSubmit(reqVo));
    }

    /**
     * 获取银行卡列表
     * @param reqVo 继承了分页对象，含公司id
     * @return 银行卡列表分页对象
     */
    @RequestMapping(value = "/bankCardList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<CompanyBankCardVo>> bankCardList(@RequestBody BankCardListReqVo reqVo){
        return ResponseResult.result(companyServiceImpl.getBankCardList(reqVo));
    }

    /**y
     * 分页查询公司信息
     * @param reqVo 继承了分页对象
     * @return 公司列表分页对象
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<CompanyVo>> list(@RequestBody ListCompanyReqVo reqVo){
        return ResponseResult.result(companyServiceImpl.list(reqVo));
    }

    /**y
     * 胖丁查询用户，公司和公司扩展表信息以及银行卡列表
     * @param reqVo 包含公司id的请求对象
     * @return 封装了用户，公司，公司扩展表和银行卡列表信息的对象
     */
    @RequestMapping(value = "/pdDetail", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<CompanyResVo> pdGetDetail(@RequestBody CompanyGetReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(companyServiceImpl.pdGetDetail(reqVo));
    }

    /**y
     * 商户查看详情，根据公司id返回用户信息和公司主表信息
     * @param reqVo 包含公司id的请求对象
     * @return 封装了用户，公司主表信息的对象
     */
    @RequestMapping(value = "/detail", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<DetailResVo> getDetail(@RequestBody CompanyGetReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(companyServiceImpl.getDetail(reqVo));
    }

    /**y
     * 获取我的二维码url
     * @param reqVo 公司扩展表请求对象
     * @return 公司二维码url
     */
    @RequestMapping(value = "/getQrCodeUrl", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> getQrCodeUrl(@RequestBody CompanyExtendGetReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("id",reqVo.getId())
                .checkException();
        return ResponseResult.result(companyServiceImpl.getQrCodeUrl(reqVo));
    }

    /**y
     * 根据二维码源码调用微信接口获取二维码url
     * @param reqVo 封装了公司id，页面选项的请求对象
     * @return 二维码url，目前没有调用微信接口，仅返回null
     */
    @RequestMapping(value = "/createQrCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> createQrCode(@RequestBody CreateQrCodeUrlReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .notBlankCheck("select",reqVo.getSelect())
                .checkException();
        return ResponseResult.result(companyServiceImpl.createQrCodeUrl(reqVo));
    }

    /**y
     * 添加用户
     * @param reqVo 封装了用户信息和用户角色信息的请求对象
     * @return 用户id
     */
    @RequestMapping(value = "/saveUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> saveUser(@RequestBody WebUserReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("account",reqVo.getAccount())
                .notBlankCheck("password",reqVo.getPassword())
                .notBlankCheck("phone",reqVo.getPhone())
                .checkPhoneNo("phone",reqVo.getPhone())
                .notBlankCheck("creator",reqVo.getCreator())
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(companyServiceImpl.saveUser(reqVo));
    }
}
