package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.vo.cloudvo.LoginResVo;
import com.pangding.web.authority.vo.reqvo.LoginReqVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpSession;

/**
 * @Author zhangjinyao
 * @create 2019/5/23 10:49
 */
@RestController
@RequestMapping(value="login")
public class LoginController {
    @Autowired
    RegisterService registerServiceImpl;

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<LoginResVo> computer(@RequestBody LoginReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("account or phone",reqVo.getAccountOrPhone())
                .notBlankCheck("password",reqVo.getPassword())
                .checkException();
        return ResponseResult.result(registerServiceImpl.login(reqVo));
    }
}
