package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.VerifyCodeService;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;

/**
 * @Author zhangjinyao
 * @create 2019/5/23 11:17
 */
@RestController
@RequestMapping(value="verify")
public class VerifyCodeController {
    @Autowired
    VerifyCodeService verifyCodeServiceImpl;

    /**
     * 获取验证码图片
     *
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping(value="/getImage",method= RequestMethod.GET)
    public ResponseResult getImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        verifyCodeServiceImpl.getImage(request,response);
        return new ResponseResult();
    }

    /**
     * 验证验证码
     *
     * @param request
     * @param session
     * @return
     */
    @RequestMapping(value="validImage",method=RequestMethod.GET)
    public ResponseResult<String> validImage(HttpServletRequest request, HttpSession session){
        return ResponseResult.result(verifyCodeServiceImpl.validImage(request,session));
    }
}
