package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.CompanyMsgService;
import com.pangding.web.vo.system.req.CompanyMsgReqVo;
import com.pangding.web.vo.system.res.CompanyMsgResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/companyMsg", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "公司消息类", description = "公司消息等相关操作")
public class CompanyMsgController {

    @Autowired
    private CompanyMsgService companyMsgService;


    @RequestMapping(value = "/getCompanyMsgList")
    @ApiOperation(value = "获取公司消息列表", notes = "返回公司消息列表")
    public ResponseResult<PageSizeData<CompanyMsgResVo>> getCompanyMsgList(@RequestBody CompanyMsgReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("companyId", req.getCompanyId())
                .checkException();
        return ResponseResult.result(companyMsgService.findCompanyMsgList(req));
    }

}
