package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyCodeDao;
import com.pangding.web.authority.service.CompanyCodeService;
import com.pangding.web.vo.system.pd.company.CompanyCodeVo;
import com.pangding.web.vo.system.req.company.CompanyCodeReqVo;
import com.pangding.web.vo.system.res.company.CompanyCodeResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CompanyCodeServiceImpl implements CompanyCodeService {

    @Autowired
    private CompanyCodeDao companyCodeDao;

    @Override
    public CompanyCodeResVo findCodeLink(CompanyCodeReqVo req){
        CompanyCodeResVo companyCodeResVo = companyCodeDao.load(req, CompanyCodeResVo.class);
        return companyCodeResVo;
    }

    /**
     * 找到公司的二维码列表
     * @param req
     * @return
     */
    @Override
    public List<CompanyCodeResVo> findCodeList(CompanyCodeReqVo req){
        List<CompanyCodeResVo> companyCodeResVoList = companyCodeDao.loadList(req, CompanyCodeResVo.class);
        return companyCodeResVoList;
    }

    @Override
    public String saveComapnyCode(CompanyCodeReqVo req){
        CompanyCodeVo companyCodeVo = new CompanyCodeVo();
        ObjectHelper.writeWithFrom(companyCodeVo, req);
        companyCodeVo.setCompanyCodeId(StringHelper.getNewID());
        return companyCodeDao.create(companyCodeVo);
    }

}
