package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyBankCardDao;
import com.pangding.web.authority.dao.CompanyExtendDao;
import com.pangding.web.authority.service.FinanceService;
import com.pangding.web.authority.vo.reqvo.CompanyExtendGetReqVo;
import com.pangding.web.authority.vo.reqvo.WithdrawalReqVo;
import com.pangding.web.authority.vo.resvo.WithdrawalResVo;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.yanzuoguang.util.exception.CodeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/6/18 20:01
 */
@Service
public class FinanceServiceImpl implements FinanceService {
    @Autowired
    private CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    private CompanyBankCardDao companyBankCardDaoImpl;

    @Override
    public WithdrawalResVo withdrawal(WithdrawalReqVo reqVo) {
        /*返回对象*/
        WithdrawalResVo resVo = new WithdrawalResVo();

        CompanyExtendGetReqVo getReqVo = new CompanyExtendGetReqVo();
        getReqVo.setId(reqVo.getCompanyId());
        CompanyExtendVo extendVo = companyExtendDaoImpl.load(getReqVo,CompanyExtendVo.class);
        if (null == extendVo ){
            throw new CodeException("未查到该公司数据");
        }
        resVo.setWithdrawTotalCash(extendVo.getWithdrawTotalCash());
        resVo.setCompanyExtend(extendVo);

        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDaoImpl.loadList(reqVo,CompanyBankCardVo.class);
        if (null == companyBankCardVoList || companyBankCardVoList.isEmpty()){
            throw new CodeException("该公司暂无银行卡信息，请添加");
        }
        resVo.setBankCardVoList(companyBankCardVoList);
        return resVo;
    }
}
